/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class Attribute
implements Constants {
    private Schema schema;
    private String name;
    private QName type;
    private static final int MAX_LENGTH = 255;
    private static final Pattern pattern = Pattern.compile("[\\s:]");

    public Attribute(Schema schema) {
        this.schema = schema;
    }

    public String toString() {
        return "Attribute{name=" + this.name + '}';
    }

    public String getName() {
        return this.name;
    }

    public QName getType() {
        return this.type;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        this.name = parser.getAttributeValue(null, "name");
        if (this.name == null) {
            throw new WsdlParseException("attribute name can not be null at: " + parser.getPositionDescription());
        }
        if ("".equals(this.name)) {
            throw new WsdlParseException("attribute name can not be empty at: " + parser.getPositionDescription());
        }
        if (this.name.length() > 255) {
            throw new WsdlParseException("attribute name '" + this.name + "' bigger than max length: " + 255);
        }
        Matcher matcher = pattern.matcher(this.name);
        if (matcher.find()) {
            throw new WsdlParseException("attribute name '" + this.name + "' is not a valid attribute name");
        }
        String t = parser.getAttributeValue(null, "type");
        if (t != null) {
            this.type = ParserUtil.toQName(t, parser);
        }
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("simpleType".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    if (this.type != null) {
                        throw new WsdlParseException("type should not be specified: " + parser.getPositionDescription());
                    }
                    SimpleType st = new SimpleType(this.schema);
                    st.read(parser, name);
                    this.type = new QName("http://www.w3.org/2001/XMLSchema", "string");
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("attribute".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    break;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'attribute'");
            }
            eventType = parser.next();
        }
        if (this.type == null) {
            throw new WsdlParseException("type not specified for attribute: " + this.name);
        }
    }
}

