/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transform.stream.IStream;

public class SingleThreadedPipelineExecutor {
    private List<TransformMetaDataCombi> transforms;
    private Pipeline pipeline;
    private boolean[] done;
    private int nrDone;
    private int exceptionsRaisedCounter;
    private boolean handleExceptionsExternally;
    private TransformMetaDataCombi inProcessCombi;
    private List<List<IStream>> transformInfoStreams;
    private List<List<IRowSet>> transformInfoRowSets;
    private ILogChannel log;
    private static final Class<?> PKG = SingleThreadedPipelineExecutor.class;
    private static final String CONST_SEPARATOR = "-------------------------------------------------------";
    private boolean clearingMetricsPerIteration = true;

    public SingleThreadedPipelineExecutor(Pipeline pipeline) {
        this.initializeObject(pipeline, false);
    }

    public SingleThreadedPipelineExecutor(Pipeline pipeline, boolean handleExceptionsExternally) {
        this.initializeObject(pipeline, handleExceptionsExternally);
    }

    public void initializeObject(Pipeline pipeline, boolean handleExceptionsExternally) {
        this.pipeline = pipeline;
        this.handleExceptionsExternally = handleExceptionsExternally;
        this.log = pipeline.getLogChannel();
        this.transforms = pipeline.getTransforms();
        this.sortTransforms();
        this.done = new boolean[this.transforms.size()];
        this.nrDone = 0;
        this.transformInfoStreams = new ArrayList<List<IStream>>();
        this.transformInfoRowSets = new ArrayList<List<IRowSet>>();
        for (TransformMetaDataCombi combi : this.transforms) {
            List<IStream> infoStreams = combi.transformMeta.getTransform().getTransformIOMeta().getInfoStreams();
            this.transformInfoStreams.add(infoStreams);
            ArrayList<IRowSet> infoRowSets = new ArrayList<IRowSet>();
            for (IStream infoStream : infoStreams) {
                IRowSet infoRowSet = pipeline.findRowSet(infoStream.getTransformName(), 0, combi.transformName, 0);
                if (infoRowSet == null) continue;
                infoRowSets.add(infoRowSet);
            }
            this.transformInfoRowSets.add(infoRowSets);
        }
    }

    private void sortTransforms() {
        this.pipeline.getPipelineMeta().clearCaches();
        boolean testing = true;
        int transformsMinSize = 0;
        int transformsSize = this.transforms.size();
        int windowShrinkThreshold = (int)Math.round((double)transformsSize * 0.75);
        int totalIterations = transformsSize * 2;
        int actualIterations = 0;
        boolean isBefore = false;
        boolean forwardChange = false;
        boolean backwardChange = false;
        boolean lastForwardChange = true;
        boolean keepSortingForward = true;
        TransformMetaDataCombi one = null;
        TransformMetaDataCombi two = null;
        StringBuilder tLogString = new StringBuilder();
        tLogString.append(CONST_SEPARATOR).append("\n");
        tLogString.append("--SingleThreadedPipelineExecutor.sortTransforms(cocktail)").append("\n");
        tLogString.append("--Pipeline: ").append(this.pipeline.getName()).append("\n");
        tLogString.append("-").append("\n");
        long startTime = System.currentTimeMillis();
        for (int x = 0; x < totalIterations; ++x) {
            if (keepSortingForward) {
                for (int y = transformsMinSize; y < transformsSize - 1; ++y) {
                    one = this.transforms.get(y);
                    two = this.transforms.get(y + 1);
                    isBefore = this.pipeline.getPipelineMeta().findPrevious(one.transformMeta, two.transformMeta);
                    if (!isBefore) continue;
                    this.transforms.set(y, two);
                    this.transforms.set(y + 1, one);
                    forwardChange = true;
                }
            }
            for (int z = transformsSize - 1; z > transformsMinSize; --z) {
                one = this.transforms.get(z);
                two = this.transforms.get(z - 1);
                isBefore = this.pipeline.getPipelineMeta().findPrevious(one.transformMeta, two.transformMeta);
                if (isBefore) continue;
                this.transforms.set(z, two);
                this.transforms.set(z - 1, one);
                backwardChange = true;
            }
            if (x > windowShrinkThreshold && !forwardChange && --transformsSize <= transformsMinSize) {
                if (!testing) break;
                tLogString.append(String.format("transformsMinSize:%s  transformsSize:%s", transformsMinSize, transformsSize));
                tLogString.append("transformsSize is <= transformsMinSize.. exiting outer sort loop. index:" + x).append("\n");
                break;
            }
            if (x > windowShrinkThreshold && !backwardChange && ++transformsMinSize >= transformsSize) {
                if (!testing) break;
                tLogString.append(String.format("transformsMinSize:%s  transformsSize:%s", transformsMinSize, transformsSize)).append("\n");
                tLogString.append("transformsMinSize is >= transformsSize.. exiting outer sort loop. index:" + x).append("\n");
                break;
            }
            ++actualIterations;
            if (!forwardChange && !backwardChange) {
                if (!testing) break;
                tLogString.append(String.format("exiting outer loop because no change was detected going forward or backward. index:%s  min:%s  max:%s", x, transformsMinSize, transformsSize)).append("\n");
                break;
            }
            if (keepSortingForward && x > 0 && !lastForwardChange && !forwardChange) {
                keepSortingForward = false;
            }
            lastForwardChange = forwardChange;
            forwardChange = false;
            backwardChange = false;
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        tLogString.append(CONST_SEPARATOR).append("\n");
        tLogString.append("Transforms sort time: " + totalTime + "ms").append("\n");
        tLogString.append("Total iterations: " + actualIterations).append("\n");
        tLogString.append("Transform count: " + this.transforms.size()).append("\n");
        tLogString.append("Transforms after sort: ").append("\n");
        for (TransformMetaDataCombi combi : this.transforms) {
            tLogString.append(combi.transform.getTransformName()).append("\n");
        }
        tLogString.append(CONST_SEPARATOR).append("\n");
        if (this.log.isDetailed()) {
            this.log.logDetailed(tLogString.toString());
        }
    }

    public boolean init() {
        for (TransformMetaDataCombi combi : this.transforms) {
            boolean ok = combi.transform.init();
            if (ok) continue;
            return false;
        }
        return true;
    }

    public boolean oneIteration() throws HopException {
        this.exceptionsRaisedCounter = 0;
        try {
            for (int s = 0; s < this.transforms.size() && !this.pipeline.isStopped(); ++s) {
                TransformMetaDataCombi combi;
                if (this.done[s]) continue;
                this.inProcessCombi = combi = this.transforms.get(s);
                boolean transformDone = false;
                List<IRowSet> infoRowSets = this.transformInfoRowSets.get(s);
                for (IRowSet rowSet : infoRowSets) {
                    boolean once = true;
                    while (once || rowSet.size() > 0 && !transformDone) {
                        once = false;
                        boolean bl = transformDone = !combi.transform.processRow();
                        if (combi.transform.getErrors() <= 0L) continue;
                        return false;
                    }
                }
                List<IRowSet> rowSets = combi.transform.getInputRowSets();
                if (rowSets.isEmpty()) {
                    while (!transformDone && !this.pipeline.isStopped()) {
                        boolean bl = transformDone = !combi.transform.processRow();
                        if (combi.transform.getErrors() <= 0L) continue;
                        return false;
                    }
                } else {
                    int nrRows = 0;
                    for (IRowSet rowSet : rowSets) {
                        nrRows += rowSet.size();
                    }
                    for (int i = 0; i < nrRows; ++i) {
                        boolean bl = transformDone = !combi.transform.processRow();
                        if (combi.transform.getErrors() <= 0L) continue;
                        return false;
                    }
                }
                combi.transform.batchComplete();
                if (transformDone) {
                    ++this.nrDone;
                }
                this.done[s] = transformDone;
            }
        }
        catch (Exception e) {
            if (this.handleExceptionsExternally) {
                this.log.logDebug("An exception was raised during a transform's execution: " + this.inProcessCombi.transformName);
                ++this.exceptionsRaisedCounter;
            }
            throw new HopException("Error performing an iteration in a single threaded pipeline", (Throwable)e);
        }
        return this.nrDone < this.transforms.size() && !this.pipeline.isStopped();
    }

    public void buildExecutionSummary() {
        for (TransformMetaDataCombi combi : this.transforms) {
            long li = combi.transform.getLinesInput();
            long lo = combi.transform.getLinesOutput();
            long lr = combi.transform.getLinesRead();
            long lw = combi.transform.getLinesWritten();
            long lu = combi.transform.getLinesUpdated();
            long lj = combi.transform.getLinesRejected();
            long e = combi.transform.getErrors();
            ILogChannel tLog = combi.transform.getLogChannel();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || e > 0L) {
                tLog.logBasic(BaseMessages.getString(PKG, (String)"SingleThreadedPipeline.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
            } else {
                tLog.logDetailed(BaseMessages.getString(PKG, (String)"SingleThreadedPipeline.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lu), String.valueOf(e + lj)}));
            }
            if (!this.clearingMetricsPerIteration) continue;
            ((BaseTransform)combi.transform).setLinesInput(0L);
            ((BaseTransform)combi.transform).setLinesOutput(0L);
            ((BaseTransform)combi.transform).setLinesWritten(0L);
            ((BaseTransform)combi.transform).setLinesRead(0L);
            ((BaseTransform)combi.transform).setLinesSkipped(0L);
            ((BaseTransform)combi.transform).setLinesUpdated(0L);
            combi.transform.setLinesRejected(0L);
        }
    }

    protected int getTotalRows(List<IRowSet> rowSets) {
        int total = 0;
        for (IRowSet rowSet : rowSets) {
            total += rowSet.size();
        }
        return total;
    }

    public long getErrors() {
        return this.pipeline.getErrors() + this.exceptionsRaisedCounter;
    }

    public Result getResult() {
        return this.pipeline.getResult();
    }

    public boolean isStopped() {
        return this.pipeline.isStopped();
    }

    public void startBundle() throws HopException {
        for (TransformMetaDataCombi combi : this.pipeline.getTransforms()) {
            combi.transform.startBundle();
        }
    }

    public void finishBundle() throws HopException {
        for (TransformMetaDataCombi combi : this.pipeline.getTransforms()) {
            combi.transform.finishBundle();
        }
    }

    public void dispose() {
        for (TransformMetaDataCombi combi : this.pipeline.getTransforms()) {
            combi.transform.setOutputDone();
        }
        for (TransformMetaDataCombi combi : this.transforms) {
            combi.transform.dispose();
            combi.transform.markStop();
        }
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public void clearError() {
        this.pipeline.clearError();
    }

    @Generated
    public boolean isClearingMetricsPerIteration() {
        return this.clearingMetricsPerIteration;
    }

    @Generated
    public void setClearingMetricsPerIteration(boolean clearingMetricsPerIteration) {
        this.clearingMetricsPerIteration = clearingMetricsPerIteration;
    }
}

