/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ifnull;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ifnull.Field;
import org.apache.hop.pipeline.transforms.ifnull.IfNull;
import org.apache.hop.pipeline.transforms.ifnull.IfNullData;
import org.apache.hop.pipeline.transforms.ifnull.ValueType;

@Transform(id="IfNull", image="ifnull.svg", name="i18n::IfNull.Name", description="i18n::IfNull.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::IfNullMeta.keyword"}, documentationUrl="/pipeline/transforms/ifnull.html")
public class IfNullMeta
extends BaseTransformMeta<IfNull, IfNullData> {
    private static final Class<?> PKG = IfNullMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupKey="FIELDS", injectionGroupDescription="IfNull.Injection.FIELDS")
    private List<Field> fields;
    @HopMetadataProperty(groupKey="valuetypes", key="valuetype", injectionGroupKey="VALUE_TYPES", injectionGroupDescription="IfNull.Injection.VALUE_TYPES")
    private List<ValueType> valueTypes = new ArrayList<ValueType>();
    @HopMetadataProperty(key="selectFields", injectionKey="SELECT_FIELDS", injectionKeyDescription="IfNull.Injection.SELECT_FIELDS")
    private boolean selectFields;
    @HopMetadataProperty(key="selectValuesType", injectionKey="SELECT_VALUES_TYPE", injectionKeyDescription="IfNull.Injection.SELECT_VALUES_TYPE")
    private boolean selectValuesType;
    @HopMetadataProperty(key="replaceAllByValue", injectionKey="REPLACE_ALL_BY_VALUE", injectionKeyDescription="IfNull.Injection.REPLACE_ALL_BY_VALUE")
    private String replaceAllByValue;
    @HopMetadataProperty(key="replaceAllMask", injectionKey="REPLACE_ALL_MASK", injectionKeyDescription="IfNull.Injection.REPLACE_ALL_MASK")
    private String replaceAllMask;
    @HopMetadataProperty(key="setEmptyStringAll", injectionKey="SET_EMPTY_STRING_ALL", injectionKeyDescription="IfNull.Injection.SET_EMPTY_STRING_ALL")
    private boolean setEmptyStringAll;

    public IfNullMeta() {
        this.fields = new ArrayList<Field>();
    }

    public IfNullMeta(IfNullMeta meta) {
        this();
        this.selectFields = meta.selectFields;
        this.selectValuesType = meta.selectValuesType;
        this.replaceAllByValue = meta.replaceAllByValue;
        this.replaceAllMask = meta.replaceAllMask;
        this.setEmptyStringAll = meta.setEmptyStringAll;
        for (Field field : meta.fields) {
            this.fields.add(new Field(field));
        }
        for (ValueType vt : meta.valueTypes) {
            this.valueTypes.add(new ValueType(vt));
        }
    }

    public boolean isSetEmptyStringAll() {
        return this.setEmptyStringAll;
    }

    public void setSetEmptyStringAll(boolean setEmptyStringAll) {
        this.setEmptyStringAll = setEmptyStringAll;
    }

    public Object clone() {
        return new IfNullMeta(this);
    }

    public boolean isSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(boolean selectFields) {
        this.selectFields = selectFields;
    }

    public void setSelectValuesType(boolean selectValuesType) {
        this.selectValuesType = selectValuesType;
    }

    public boolean isSelectValuesType() {
        return this.selectValuesType;
    }

    public void setReplaceAllByValue(String replaceValue) {
        this.replaceAllByValue = replaceValue;
    }

    public String getReplaceAllByValue() {
        return this.replaceAllByValue;
    }

    public void setReplaceAllMask(String replaceAllMask) {
        this.replaceAllMask = replaceAllMask;
    }

    public String getReplaceAllMask() {
        return this.replaceAllMask;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public List<ValueType> getValueTypes() {
        return this.valueTypes;
    }

    public void setValueTypes(List<ValueType> valueTypes) {
        this.valueTypes = valueTypes;
    }

    public void setDefault() {
        this.replaceAllByValue = null;
        this.replaceAllMask = null;
        this.selectFields = false;
        this.selectValuesType = false;
        this.setEmptyStringAll = false;
        this.valueTypes = new ArrayList<ValueType>();
        this.fields = new ArrayList<Field>();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.isEmpty()) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.TransformRecevingData", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (Field field : this.fields) {
                int idx = prev.indexOfValue(field.getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + field.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (!this.fields.isEmpty()) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

