/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.IHopPerspectiveListener;

public class HopPerspectiveManager {
    private final HopGui hopGui;
    private final Map<Class<? extends IHopPerspective>, IHopPerspective> perspectivesMap;
    private final ConcurrentLinkedQueue<IHopPerspectiveListener> listeners;

    public HopPerspectiveManager(HopGui hopGui) {
        this.hopGui = hopGui;
        this.perspectivesMap = new HashMap<Class<? extends IHopPerspective>, IHopPerspective>();
        this.listeners = new ConcurrentLinkedQueue();
    }

    public void addPerspective(IHopPerspective perspective) {
        this.perspectivesMap.put(perspective.getClass(), perspective);
    }

    public IHopPerspective getComposite(Class<? extends IHopPerspective> perspectiveClass) {
        return this.perspectivesMap.get(perspectiveClass);
    }

    public void showPerspective(Class<? extends IHopPerspective> perspectiveClass) {
        for (IHopPerspective perspective : this.perspectivesMap.values()) {
            if (!perspective.getClass().equals(perspectiveClass)) continue;
            this.hopGui.setActivePerspective(perspective);
        }
    }

    public <T extends IHopPerspective> T findPerspective(Class<T> perspectiveClass) {
        for (IHopPerspective perspective : this.perspectivesMap.values()) {
            if (!perspective.getClass().equals(perspectiveClass)) continue;
            return (T)((IHopPerspective)perspectiveClass.cast(perspective));
        }
        return null;
    }

    public IHopPerspective findPerspective(IHopFileType hopFileType) {
        for (IHopPerspective perspective : this.getPerspectives()) {
            for (IHopFileType fileType : perspective.getSupportedHopFileTypes()) {
                if (!hopFileType.equals(fileType)) continue;
                return perspective;
            }
        }
        return null;
    }

    public IHopFileType findFileTypeHandler(IHasFilename fileMetadata) {
        for (IHopPerspective perspective : this.getPerspectives()) {
            for (IHopFileType fileType : perspective.getSupportedHopFileTypes()) {
                if (!fileType.supportsFile(fileMetadata)) continue;
                return fileType;
            }
        }
        return new EmptyFileType();
    }

    public List<IHopPerspective> getPerspectives() {
        return new ArrayList<IHopPerspective>(this.perspectivesMap.values());
    }

    public void addPerspectiveListener(IHopPerspectiveListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removePerspectiveListener(IHopPerspectiveListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyPerspectiveActivated(IHopPerspective perspective) {
        for (IHopPerspectiveListener listener : this.listeners) {
            listener.perspectiveActivated(perspective);
        }
    }

    private List<Class<? extends IHopPerspective>> getSortedClasses() {
        ArrayList<Class<? extends IHopPerspective>> list = new ArrayList<Class<? extends IHopPerspective>>(this.perspectivesMap.keySet());
        list.sort(Comparator.comparing(c -> c.getAnnotation(HopPerspectivePlugin.class).id()));
        return list;
    }

    public void showPreviousPerspective(IHopPerspective currentPerspective) {
        Class<? extends IHopPerspective> previousClass;
        IHopPerspective previousPerspective;
        if (currentPerspective == null) {
            return;
        }
        List<Class<? extends IHopPerspective>> list = this.getSortedClasses();
        int index = list.indexOf(currentPerspective.getClass());
        if (index > 0 && (previousPerspective = this.perspectivesMap.get(previousClass = list.get(index - 1))) != null) {
            previousPerspective.activate();
        }
    }

    public void showNextPerspective(IHopPerspective currentPerspective) {
        Class<? extends IHopPerspective> nextClass;
        IHopPerspective nextPerspective;
        if (currentPerspective == null) {
            return;
        }
        List<Class<? extends IHopPerspective>> list = this.getSortedClasses();
        int index = list.indexOf(currentPerspective.getClass());
        if (index < list.size() - 1 && (nextPerspective = this.perspectivesMap.get(nextClass = list.get(index + 1))) != null) {
            nextPerspective.activate();
        }
    }
}

