/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Date;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.TreeBuilder;

public abstract class Builder
implements Receiver {
    public static final int LINKED_TREE = 0;
    public static final int STANDARD_TREE = 0;
    public static final int TINY_TREE = 1;
    protected PipelineConfiguration pipe;
    protected Configuration config;
    protected NamePool namePool;
    protected String systemId;
    protected NodeInfo currentRoot;
    protected boolean lineNumbering = false;
    protected boolean started = false;
    protected boolean timing = false;
    private long startTime;

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
        this.config = pipelineConfiguration.getConfiguration();
        this.namePool = this.config.getNamePool();
        this.lineNumbering = this.lineNumbering || this.config.isLineNumbering();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void open() throws XPathException {
        if (this.timing) {
            System.err.println("Building tree for " + this.getSystemId() + " using " + this.getClass());
            this.startTime = new Date().getTime();
        }
    }

    public void close() throws XPathException {
        if (this.timing) {
            long l = new Date().getTime();
            System.err.println("Tree built in " + (l - this.startTime) + " milliseconds");
            if (this.currentRoot instanceof TinyDocumentImpl) {
                ((TinyDocumentImpl)this.currentRoot).showSize();
            }
            this.startTime = l;
        }
    }

    public void startDocument(int n) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public NodeInfo getCurrentRoot() {
        return this.currentRoot;
    }

    public static NodeInfo build(Source source, Stripper stripper, Configuration configuration) throws XPathException {
        return Builder.build(source, stripper, configuration.makePipelineConfiguration());
    }

    public static NodeInfo build(Source source, Stripper stripper, PipelineConfiguration pipelineConfiguration) throws XPathException {
        NodeInfo nodeInfo;
        Configuration configuration = pipelineConfiguration.getConfiguration();
        if (source == null) {
            throw new NullPointerException("Source supplied to builder cannot be null");
        }
        if (source instanceof DOMSource || source instanceof NodeInfo) {
            nodeInfo = Controller.unravel(source, configuration);
            if (stripper != null) {
                DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
                StrippedDocument strippedDocument = new StrippedDocument(documentInfo, stripper);
                nodeInfo = strippedDocument.wrap(nodeInfo);
            }
        } else {
            Builder builder = configuration.getTreeModel() == 1 ? new TinyBuilder() : new TreeBuilder();
            builder.setPipelineConfiguration(pipelineConfiguration);
            if (configuration.isLineNumbering() || source instanceof AugmentedSource && ((AugmentedSource)source).isLineNumbering()) {
                builder.setLineNumbering(true);
            }
            Receiver receiver = builder;
            if (stripper != null) {
                stripper.setUnderlyingReceiver(builder);
                receiver = stripper;
            }
            try {
                new Sender(pipelineConfiguration).send(source, receiver);
            }
            catch (XPathException xPathException) {
                throw DynamicError.makeDynamicError(xPathException);
            }
            nodeInfo = builder.getCurrentRoot();
        }
        return nodeInfo;
    }
}

