/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.errorhandling;

import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface BadRecordRouter
extends Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized BadRecordRouter THROWING_ROUTER = new ThrowingBadRecordRouter();
    public static final @UnknownKeyFor @NonNull @Initialized BadRecordRouter RECORDING_ROUTER = new RecordingBadRecordRouter();
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BadRecord> BAD_RECORD_TAG = new TupleTag();

    public <RecordT> void route( @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver var1, RecordT var2, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> var3, @Nullable @UnknownKeyFor @Initialized Exception var4, @UnknownKeyFor @NonNull @Initialized String var5) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public <RecordT> void route(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext var1, RecordT var2, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> var3, @Nullable @UnknownKeyFor @Initialized Exception var4, @UnknownKeyFor @NonNull @Initialized String var5, @UnknownKeyFor @NonNull @Initialized BoundedWindow var6) throws @UnknownKeyFor @NonNull @Initialized Exception;

    public static class RecordingBadRecordRouter
    implements BadRecordRouter {
        @Override
        public <RecordT> void route( @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver, RecordT record, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> coder, @Nullable @UnknownKeyFor @Initialized Exception exception, @UnknownKeyFor @NonNull @Initialized String description) throws @UnknownKeyFor @NonNull @Initialized Exception {
            outputReceiver.get(BAD_RECORD_TAG).output(BadRecord.fromExceptionInformation(record, coder, exception, description));
        }

        @Override
        public <RecordT> void route(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c, RecordT record, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> coder, @Nullable @UnknownKeyFor @Initialized Exception exception, @UnknownKeyFor @NonNull @Initialized String description, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
            c.output(BAD_RECORD_TAG, BadRecord.fromExceptionInformation(record, coder, exception, description), window.maxTimestamp(), window);
        }
    }

    public static class ThrowingBadRecordRouter
    implements BadRecordRouter {
        @Override
        public <RecordT> void route( @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver, RecordT record, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> coder, @Nullable @UnknownKeyFor @Initialized Exception exception, @UnknownKeyFor @NonNull @Initialized String description) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.route(record, exception);
        }

        @Override
        public <RecordT> void route(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c, RecordT record, @Nullable @UnknownKeyFor @Initialized Coder<RecordT> coder, @Nullable @UnknownKeyFor @Initialized Exception exception, @UnknownKeyFor @NonNull @Initialized String description, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.route(record, exception);
        }

        private <RecordT> void route(RecordT record, @Nullable @UnknownKeyFor @Initialized Exception exception) throws @UnknownKeyFor @NonNull @Initialized Exception {
            if (exception != null) {
                throw exception;
            }
            Preconditions.checkArgumentNotNull(record);
            String encodedRecord = BadRecord.Record.builder().addHumanReadableJson(record).build().getHumanReadableJsonRecord();
            if (encodedRecord == null) {
                encodedRecord = "Unable to serialize bad record";
            }
            throw new RuntimeException("Encountered Bad Record: " + encodedRecord);
        }
    }
}

