/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.CoGroup;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Join {
    public static final @UnknownKeyFor @NonNull @Initialized String LHS_TAG = "lhs";
    public static final @UnknownKeyFor @NonNull @Initialized String RHS_TAG = "rhs";

    public static <LhsT, RhsT> @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> innerJoin(@UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
        return new Impl(JoinType.INNER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> fullOuterJoin(@UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
        return new Impl(JoinType.OUTER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> leftOuterJoin(@UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
        return new Impl(JoinType.LEFT_OUTER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> rightOuterJoin(@UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
        return new Impl(JoinType.RIGHT_OUTER, (PCollection)rhs);
    }

    public static <LhsT, RhsT> @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> innerBroadcastJoin(@UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
        return new Impl(JoinType.INNER_BROADCAST, (PCollection)rhs);
    }

    public static <LhsT, RhsT> @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> leftOuterBroadcastJoin(@UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
        return new Impl(JoinType.LEFT_OUTER_BROADCAST, (PCollection)rhs);
    }

    public static class Impl<@UnknownKeyFor LhsT, @UnknownKeyFor RhsT>
    extends PTransform<PCollection<LhsT>, PCollection<Row>> {
        private final @UnknownKeyFor @NonNull @Initialized JoinType joinType;
        private final transient @UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs;
        private final @Nullable @UnknownKeyFor @Initialized FieldsEqual.Impl predicate;

        private Impl(@UnknownKeyFor @NonNull @Initialized JoinType joinType, @UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs) {
            this(joinType, rhs, null);
        }

        private Impl(@UnknownKeyFor @NonNull @Initialized JoinType joinType, @UnknownKeyFor @NonNull @Initialized PCollection<RhsT> rhs, @UnknownKeyFor @NonNull @Initialized FieldsEqual.Impl predicate) {
            this.joinType = joinType;
            this.rhs = rhs;
            this.predicate = predicate;
        }

        public @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> using(String ... fieldNames) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, FieldsEqual.left(fieldNames).right(fieldNames));
        }

        public @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> using(Integer ... fieldIds) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, FieldsEqual.left(fieldIds).right(fieldIds));
        }

        public @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> using(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, FieldsEqual.left(fieldAccessDescriptor).right(fieldAccessDescriptor));
        }

        public @UnknownKeyFor @NonNull @Initialized Impl<LhsT, RhsT> on(@UnknownKeyFor @NonNull @Initialized FieldsEqual.Impl predicate) {
            return new Impl<LhsT, RhsT>(this.joinType, this.rhs, predicate);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection lhs) {
            FieldsEqual.Impl resolvedPredicate = this.predicate.resolve(lhs.getSchema(), this.rhs.getSchema());
            PCollectionTuple tuple = PCollectionTuple.of(Join.LHS_TAG, lhs).and(Join.RHS_TAG, this.rhs);
            switch (this.joinType) {
                case INNER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs)).crossProductJoin());
                }
                case INNER_BROADCAST: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withSideInput()).crossProductJoin());
                }
                case OUTER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs).withOptionalParticipation()).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withOptionalParticipation()).crossProductJoin());
                }
                case LEFT_OUTER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withOptionalParticipation()).crossProductJoin());
                }
                case LEFT_OUTER_BROADCAST: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs)).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs).withOptionalParticipation().withSideInput()).crossProductJoin());
                }
                case RIGHT_OUTER: {
                    return tuple.apply(CoGroup.join(Join.LHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.lhs).withOptionalParticipation()).join(Join.RHS_TAG, CoGroup.By.fieldAccessDescriptor(resolvedPredicate.rhs)).crossProductJoin());
                }
            }
            throw new RuntimeException("Unexpected join type");
        }
    }

    private static enum JoinType {
        INNER,
        OUTER,
        LEFT_OUTER,
        RIGHT_OUTER,
        INNER_BROADCAST,
        LEFT_OUTER_BROADCAST;

    }

    public static class FieldsEqual {
        public static @UnknownKeyFor @NonNull @Initialized Impl left(String ... fieldNames) {
            return new Impl(FieldAccessDescriptor.withFieldNames(fieldNames), FieldAccessDescriptor.create());
        }

        public static @UnknownKeyFor @NonNull @Initialized Impl left(Integer ... fieldIds) {
            return new Impl(FieldAccessDescriptor.withFieldIds(fieldIds), FieldAccessDescriptor.create());
        }

        public static @UnknownKeyFor @NonNull @Initialized Impl left(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return new Impl(fieldAccessDescriptor, FieldAccessDescriptor.create());
        }

        public @UnknownKeyFor @NonNull @Initialized Impl right(String ... fieldNames) {
            return new Impl(FieldAccessDescriptor.create(), FieldAccessDescriptor.withFieldNames(fieldNames));
        }

        public @UnknownKeyFor @NonNull @Initialized Impl right(Integer ... fieldIds) {
            return new Impl(FieldAccessDescriptor.create(), FieldAccessDescriptor.withFieldIds(fieldIds));
        }

        public @UnknownKeyFor @NonNull @Initialized Impl right(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return new Impl(FieldAccessDescriptor.create(), fieldAccessDescriptor);
        }

        public static class Impl
        implements Serializable {
            private @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor lhs;
            private @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor rhs;

            private Impl(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor lhs, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor rhs) {
                this.lhs = lhs;
                this.rhs = rhs;
            }

            public @UnknownKeyFor @NonNull @Initialized Impl left(String ... fieldNames) {
                return new Impl(FieldAccessDescriptor.withFieldNames(fieldNames), this.rhs);
            }

            public @UnknownKeyFor @NonNull @Initialized Impl left(Integer ... fieldIds) {
                return new Impl(FieldAccessDescriptor.withFieldIds(fieldIds), this.rhs);
            }

            public @UnknownKeyFor @NonNull @Initialized Impl left(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
                return new Impl(fieldAccessDescriptor, this.rhs);
            }

            public @UnknownKeyFor @NonNull @Initialized Impl right(String ... fieldNames) {
                return new Impl(this.lhs, FieldAccessDescriptor.withFieldNames(fieldNames));
            }

            public @UnknownKeyFor @NonNull @Initialized Impl right(Integer ... fieldIds) {
                return new Impl(this.lhs, FieldAccessDescriptor.withFieldIds(fieldIds));
            }

            public @UnknownKeyFor @NonNull @Initialized Impl right(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
                return new Impl(this.lhs, fieldAccessDescriptor);
            }

            private @UnknownKeyFor @NonNull @Initialized Impl resolve(@UnknownKeyFor @NonNull @Initialized Schema lhsSchema, @UnknownKeyFor @NonNull @Initialized Schema rhsSchema) {
                return new Impl(this.lhs.resolve(lhsSchema), this.rhs.resolve(rhsSchema));
            }
        }
    }
}

