/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SortedMapCoder<@UnknownKeyFor K extends @UnknownKeyFor @NonNull @Initialized Comparable<@UnknownKeyFor @NonNull @Initialized ? super K>, @UnknownKeyFor V>
extends StructuredCoder<SortedMap<K, V>> {
    private @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

    public static <K extends Comparable<? super K>, V> @UnknownKeyFor @NonNull @Initialized SortedMapCoder<K, V> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new SortedMapCoder<K, V>(keyCoder, valueCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    private SortedMapCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized SortedMap<K, V> map, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(map, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized SortedMap<K, V> map, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (map == null) {
            throw new CoderException("cannot encode a null SortedMap");
        }
        DataOutputStream dataOutStream = new DataOutputStream(outStream);
        int size = map.size();
        dataOutStream.writeInt(size);
        if (size == 0) {
            return;
        }
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        Map.Entry<K, V> entry = iterator.next();
        while (iterator.hasNext()) {
            this.keyCoder.encode((Comparable)entry.getKey(), outStream);
            this.valueCoder.encode(entry.getValue(), outStream);
            entry = iterator.next();
        }
        this.keyCoder.encode((Comparable)entry.getKey(), outStream);
        this.valueCoder.encode(entry.getValue(), outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SortedMap<K, V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SortedMap<K, V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        DataInputStream dataInStream = new DataInputStream(inStream);
        int size = dataInStream.readInt();
        if (size == 0) {
            return Collections.emptySortedMap();
        }
        TreeMap retval = Maps.newTreeMap();
        for (int i = 0; i < size - 1; ++i) {
            Comparable key = (Comparable)this.keyCoder.decode(inStream);
            V value = this.valueCoder.decode(inStream);
            retval.put(key, value);
        }
        Comparable key = (Comparable)this.keyCoder.decode(inStream);
        V value = this.valueCoder.decode(inStream, context);
        retval.put(key, value);
        return retval;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder, this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Ordering of entries in a Map may be non-deterministic.");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.keyCoder.consistentWithEquals() && this.valueCoder.consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized SortedMap<K, V> value) {
        if (this.consistentWithEquals()) {
            return value;
        }
        HashMap ret = Maps.newHashMapWithExpectedSize((int)value.size());
        for (Map.Entry<K, V> entry : value.entrySet()) {
            ret.put(this.keyCoder.structuralValue((Comparable)entry.getKey()), this.valueCoder.structuralValue(entry.getValue()));
        }
        return ret;
    }

    @Override
    public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized SortedMap<K, V> map, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        observer.update(4L);
        if (map.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<K, V>> entries = map.entrySet().iterator();
        Map.Entry<K, V> entry = entries.next();
        while (entries.hasNext()) {
            this.keyCoder.registerByteSizeObserver((Comparable)entry.getKey(), observer);
            this.valueCoder.registerByteSizeObserver(entry.getValue(), observer);
            entry = entries.next();
        }
        this.keyCoder.registerByteSizeObserver((Comparable)entry.getKey(), observer);
        this.valueCoder.registerByteSizeObserver(entry.getValue(), observer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized SortedMap<K, V>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<SortedMap<K, V>>(){}.where(new TypeParameter<K>(){}, this.keyCoder.getEncodedTypeDescriptor()).where(new TypeParameter<V>(){}, this.valueCoder.getEncodedTypeDescriptor());
    }
}

