/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataWrapper;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.memory.MemoryMetadataProvider;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;
import org.w3c.dom.Node;

@HopMetadataWrapper(tag="mapping")
public class MappingIODefinition
implements Cloneable {
    public static final String XML_TAG = "mapping";
    private transient TransformMeta inputTransform;
    @HopMetadataProperty(key="input_transform")
    private String inputTransformName = null;
    @HopMetadataProperty(key="output_transform")
    private String outputTransformName = null;
    @HopMetadataProperty(key="description")
    private String description;
    @HopMetadataProperty(key="connector")
    private List<MappingValueRename> valueRenames = new ArrayList<MappingValueRename>();
    @HopMetadataProperty(key="main_path")
    private boolean mainDataPath = false;
    @HopMetadataProperty(key="rename_on_output")
    private boolean renamingOnOutput = false;

    public MappingIODefinition() {
    }

    public MappingIODefinition(String inputTransformName, String outputTransformName) {
        this();
        this.inputTransformName = inputTransformName;
        this.outputTransformName = outputTransformName;
    }

    public MappingIODefinition(MappingIODefinition d) {
        this();
        this.inputTransformName = d.inputTransformName;
        this.outputTransformName = d.outputTransformName;
        this.description = d.description;
        this.mainDataPath = d.mainDataPath;
        this.renamingOnOutput = d.renamingOnOutput;
        for (MappingValueRename rename : d.valueRenames) {
            this.valueRenames.add(new MappingValueRename(rename));
        }
    }

    public MappingIODefinition clone() {
        return new MappingIODefinition(this);
    }

    public MappingIODefinition(Node mappingNode) throws HopXmlException {
        this();
        XmlMetadataUtil.deSerializeFromXml((Object)this, (Node)mappingNode, MappingIODefinition.class, (IHopMetadataProvider)new MemoryMetadataProvider());
    }

    public String getXml() throws HopException {
        return XmlMetadataUtil.serializeObjectToXml((Object)this);
    }

    public String getInputTransformName() {
        return this.inputTransformName;
    }

    public void setInputTransformName(String inputTransformName) {
        this.inputTransformName = inputTransformName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOutputTransformName() {
        return this.outputTransformName;
    }

    public void setOutputTransformName(String outputTransformName) {
        this.outputTransformName = outputTransformName;
    }

    public boolean isMainDataPath() {
        return this.mainDataPath;
    }

    public void setMainDataPath(boolean mainDataPath) {
        this.mainDataPath = mainDataPath;
    }

    public boolean isRenamingOnOutput() {
        return this.renamingOnOutput;
    }

    public void setRenamingOnOutput(boolean renamingOnOutput) {
        this.renamingOnOutput = renamingOnOutput;
    }

    public List<MappingValueRename> getValueRenames() {
        return this.valueRenames;
    }

    public void setValueRenames(List<MappingValueRename> valueRenames) {
        this.valueRenames = valueRenames;
    }

    public TransformMeta getInputTransform() {
        return this.inputTransform;
    }

    public void setInputTransform(TransformMeta inputTransform) {
        this.inputTransform = inputTransform;
    }
}

