/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.EntropyInjectingFileSystem;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.OutputStreamAndPath;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.WrappingProxy;

@PublicEvolving
public class EntropyInjector {
    public static Path addEntropy(FileSystem fs, Path path) throws IOException {
        EntropyInjectingFileSystem efs = EntropyInjector.getEntropyFs(fs);
        return efs == null ? path : EntropyInjector.resolveEntropy(path, efs, true);
    }

    public static OutputStreamAndPath createEntropyAware(FileSystem fs, Path path, FileSystem.WriteMode writeMode) throws IOException {
        Path processedPath = EntropyInjector.addEntropy(fs, path);
        FSDataOutputStream out = fs.create(processedPath, writeMode);
        return new OutputStreamAndPath(out, processedPath);
    }

    public static Path removeEntropyMarkerIfPresent(FileSystem fs, Path path) {
        EntropyInjectingFileSystem efs = EntropyInjector.getEntropyFs(fs);
        if (efs == null) {
            return path;
        }
        try {
            return EntropyInjector.resolveEntropy(path, efs, false);
        }
        catch (IOException e) {
            throw new FlinkRuntimeException(e.getMessage(), e);
        }
    }

    public static boolean isEntropyInjecting(FileSystem fs, Path target) {
        EntropyInjectingFileSystem entropyFs = EntropyInjector.getEntropyFs(fs);
        return entropyFs != null && entropyFs.getEntropyInjectionKey() != null && target.getPath().contains(entropyFs.getEntropyInjectionKey());
    }

    @Nullable
    private static EntropyInjectingFileSystem getEntropyFs(FileSystem fs) {
        if (fs instanceof EntropyInjectingFileSystem) {
            return (EntropyInjectingFileSystem)((Object)fs);
        }
        if (fs instanceof WrappingProxy) {
            FileSystem delegate = (FileSystem)((WrappingProxy)((Object)fs)).getWrappedDelegate();
            return EntropyInjector.getEntropyFs(delegate);
        }
        return null;
    }

    @VisibleForTesting
    static Path resolveEntropy(Path path, EntropyInjectingFileSystem efs, boolean injectEntropy) throws IOException {
        String entropyInjectionKey = efs.getEntropyInjectionKey();
        if (entropyInjectionKey == null) {
            return path;
        }
        URI originalUri = path.toUri();
        String checkpointPath = originalUri.getPath();
        int indexOfKey = checkpointPath.indexOf(entropyInjectionKey);
        if (indexOfKey == -1) {
            return path;
        }
        StringBuilder buffer = new StringBuilder(checkpointPath.length());
        buffer.append(checkpointPath, 0, indexOfKey);
        if (injectEntropy) {
            buffer.append(efs.generateEntropy());
        }
        buffer.append(checkpointPath, indexOfKey + entropyInjectionKey.length(), checkpointPath.length());
        String rewrittenPath = buffer.toString();
        try {
            return new Path(new URI(originalUri.getScheme(), originalUri.getAuthority(), rewrittenPath, originalUri.getQuery(), originalUri.getFragment()).normalize());
        }
        catch (URISyntaxException e) {
            throw new IOException("URI format error while processing path for entropy injection", e);
        }
    }

    private EntropyInjector() {
    }
}

