/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.maven.support;

import org.appformer.maven.support.AFReleaseId;

public interface DependencyFilter {
    public static final DependencyFilter TAKE_ALL_FILTER = new DependencyFilter(){

        @Override
        public boolean accept(AFReleaseId releaseId, String scope) {
            return true;
        }
    };
    public static final DependencyFilter COMPILE_FILTER = new ExcludeScopeFilter("test", "provided");

    public boolean accept(AFReleaseId var1, String var2);

    public static class ExcludeScopeFilter
    implements DependencyFilter {
        private final String[] excludedScopes;

        public ExcludeScopeFilter(String ... excludedScopes) {
            this.excludedScopes = excludedScopes;
        }

        @Override
        public boolean accept(AFReleaseId releaseId, String scope) {
            for (String excludedScope : this.excludedScopes) {
                if (!excludedScope.equals(scope)) continue;
                return false;
            }
            return true;
        }
    }
}

