/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosException;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.PassiveCheckBytesBuilder;
import com.googlecode.jsendnsca.PassiveCheckSender;
import com.googlecode.jsendnsca.utils.IOUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.commons.lang.Validate;

public class NagiosPassiveCheckSender
implements PassiveCheckSender {
    private static final int INITIALISATION_VECTOR_SIZE = 128;
    private final NagiosSettings nagiosSettings;

    public NagiosPassiveCheckSender(NagiosSettings nagiosSettings) {
        Validate.notNull((Object)nagiosSettings, (String)"nagiosSettings cannot be null");
        this.nagiosSettings = nagiosSettings;
    }

    @Override
    public void send(MessagePayload payload) throws NagiosException, IOException {
        Validate.notNull((Object)payload, (String)"payload cannot be null");
        Socket socket = this.connectedToNagios();
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        try {
            outputStream.write(this.passiveCheck(payload, new DataInputStream(inputStream)));
            outputStream.flush();
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (IOException e) {
            throw new NagiosException("Error occurred while sending passive alert", e);
        }
        finally {
            NagiosPassiveCheckSender.close(socket, outputStream, inputStream);
        }
    }

    private Socket connectedToNagios() throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.nagiosSettings.getNagiosHost(), this.nagiosSettings.getPort()), this.nagiosSettings.getConnectTimeout());
        socket.setSoTimeout(this.nagiosSettings.getTimeout());
        return socket;
    }

    private byte[] passiveCheck(MessagePayload payload, DataInputStream inputStream) throws IOException, NagiosException {
        byte[] initVector = NagiosPassiveCheckSender.readFrom(inputStream);
        int receivedTimeStamp = inputStream.readInt();
        return new PassiveCheckBytesBuilder(this.nagiosSettings).withTimeStamp(receivedTimeStamp).withLevel(payload.getLevel()).withHostname(payload.getHostname()).withServiceName(payload.getServiceName()).withMessage(payload.getMessage()).writeCRC().encrypt(initVector).toByteArray();
    }

    private static void close(Socket socket, OutputStream outputStream, InputStream inputStream) {
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        IOUtils.closeQuietly(socket);
    }

    private static byte[] readFrom(DataInputStream inputStream) throws NagiosException, SocketTimeoutException {
        try {
            byte[] initVector = new byte[128];
            inputStream.readFully(initVector, 0, 128);
            return initVector;
        }
        catch (SocketTimeoutException ste) {
            throw ste;
        }
        catch (IOException e) {
            throw new NagiosException("Can't read initialisation vector", e);
        }
    }
}

