/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.IFSDeleteAction;
import com.ibm.as400.vaccess.IFSEditAction;
import com.ibm.as400.vaccess.IFSFilePropertiesPane;
import com.ibm.as400.vaccess.IFSRenameAction;
import com.ibm.as400.vaccess.PermissionAction;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VIFSConstants;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import javax.swing.Icon;

public class VIFSFile
implements VObject,
VIFSConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final String description_ = ResourceLoader.getText("IFS_FILE_DESCRIPTION");
    private static final Icon icon16_ = ResourceLoader.getIcon("VIFSFile16.gif", description_);
    private static final Icon icon32_ = ResourceLoader.getIcon("VIFSFile32.gif", description_);
    private static final String readAbbreviationText_ = ResourceLoader.getText("IFS_READ_ABBREVIATION");
    private static final String writeAbbreviationText_ = ResourceLoader.getText("IFS_WRITE_ABBREVIATION");
    IFSFile file_ = null;
    private transient VAction[] actions_;
    private transient boolean actionsInitialized_;
    private transient String attributes_;
    private transient VAction defaultAction_;
    private transient Date modified_;
    private transient VPropertiesPane propertiesPane_;
    private transient boolean readable_;
    private transient Long size_;
    private transient boolean writable_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient VObjectEventSupport objectEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public VIFSFile() {
        this.file_ = new IFSFile();
        this.initializeTransient();
    }

    public VIFSFile(IFSFile file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.file_ = file;
        this.initializeTransient();
    }

    public VIFSFile(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.file_ = new IFSFile(system, path);
        this.initializeTransient();
    }

    @Override
    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    @Override
    public void addVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.addVObjectListener(listener);
    }

    @Override
    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    boolean canRead() {
        return this.readable_;
    }

    boolean canWrite() {
        return this.writable_;
    }

    @Override
    public VAction[] getActions() {
        this.initializeCreationActions();
        return this.actions_;
    }

    @Override
    public VAction getDefaultAction() {
        return this.defaultAction_;
    }

    @Override
    public Icon getIcon(int size, boolean open) {
        if (size == 32) {
            return icon32_;
        }
        return icon16_;
    }

    Date getModified() {
        return this.modified_;
    }

    public String getName() {
        return this.file_.getName();
    }

    public String getParentDirectory() {
        return this.file_.getParent();
    }

    public String getPath() {
        return this.file_.getPath();
    }

    @Override
    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    @Override
    public synchronized Object getPropertyValue(Object propertyIdentifier) {
        if (propertyIdentifier == NAME_PROPERTY) {
            return this;
        }
        if (propertyIdentifier == DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (propertyIdentifier == SIZE_PROPERTY) {
            return this.size_;
        }
        if (propertyIdentifier == MODIFIED_PROPERTY) {
            return this.modified_;
        }
        if (propertyIdentifier == ATTRIBUTES_PROPERTY) {
            return this.attributes_;
        }
        return null;
    }

    long getSize() {
        return this.size_;
    }

    public AS400 getSystem() {
        return this.file_.getSystem();
    }

    @Override
    public String getText() {
        return this.file_.getName();
    }

    private void initializeCreationActions() {
        if (this.actionsInitialized_) {
            return;
        }
        String pathPrefix = this.file_.getPath().toUpperCase();
        if (pathPrefix.startsWith("/QSYS.LIB/") || pathPrefix.startsWith("/QDLS/")) {
            for (int i = 0; i < 2; ++i) {
                this.actions_[i].setEnabled(false);
            }
            this.defaultAction_ = this.actions_[4];
        }
        this.actionsInitialized_ = true;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.file_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.file_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.addVObjectListener(new VObjectListener_());
        this.actions_ = new VAction[5];
        this.actions_[0] = new IFSEditAction(this, this.file_, true);
        this.actions_[1] = new IFSEditAction(this, this.file_, false);
        this.actions_[2] = new IFSRenameAction(this, this.file_);
        this.actions_[3] = new IFSDeleteAction(this, this.file_);
        this.actions_[4] = new PermissionAction(this.file_);
        this.defaultAction_ = this.actions_[0];
        this.actionsInitialized_ = false;
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectEventSupport_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new IFSFilePropertiesPane(this);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
        this.attributes_ = "";
        this.modified_ = new Date();
        this.readable_ = false;
        this.size_ = 0L;
        this.writable_ = false;
    }

    @Override
    public void load() {
        this.workingEventSupport_.fireStartWorking();
        this.initializeCreationActions();
        try {
            this.size_ = this.file_.length();
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
            this.size_ = 0L;
        }
        try {
            this.modified_ = new Date(this.file_.lastModified());
        }
        catch (Exception e) {
            this.modified_ = new Date(0L);
            this.errorEventSupport_.fireError(e);
        }
        try {
            this.readable_ = this.file_.canRead();
        }
        catch (Exception e) {
            this.readable_ = false;
            this.errorEventSupport_.fireError(e);
        }
        try {
            this.writable_ = this.file_.canWrite();
        }
        catch (Exception e) {
            this.writable_ = false;
            this.errorEventSupport_.fireError(e);
        }
        StringBuilder buffer = new StringBuilder();
        if (this.readable_) {
            buffer.append(readAbbreviationText_);
        }
        if (this.writable_) {
            buffer.append(writeAbbreviationText_);
        }
        this.attributes_ = buffer.toString();
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    @Override
    public void removeVObjectListener(VObjectListener listener) {
        this.objectEventSupport_.removeVObjectListener(listener);
    }

    @Override
    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setPath(String path) throws PropertyVetoException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.file_.setPath(path);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        this.file_.setSystem(system);
    }

    public String toString() {
        return this.file_.getName();
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        @Override
        public void objectChanged(VObjectEvent event) {
            VIFSFile.this.file_.clearCachedAttributes();
        }

        @Override
        public void objectCreated(VObjectEvent event) {
        }

        @Override
        public void objectDeleted(VObjectEvent event) {
        }
    }
}

