/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.workflow.transform;

import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.reflection.workflow.transform.WorkflowLoggingData;
import org.apache.hop.reflection.workflow.transform.WorkflowLoggingMeta;
import org.apache.hop.workflow.ActionResult;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public class WorkflowLogging
extends BaseTransform<WorkflowLoggingMeta, WorkflowLoggingData> {
    private IWorkflowEngine<WorkflowMeta> loggingWorkflow;
    private String loggingPhase;

    public WorkflowLogging(TransformMeta transformMeta, WorkflowLoggingMeta meta, WorkflowLoggingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.loggingWorkflow == null) {
            if (this.isBasic()) {
                this.logBasic("This transform will produce output when called by the Pipeline Log configuration");
            }
            this.setOutputDone();
            return false;
        }
        RowMeta outputRowMeta = new RowMeta();
        ((WorkflowLoggingMeta)this.meta).getFields((IRowMeta)outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        WorkflowMeta workflowMeta = this.loggingWorkflow.getWorkflowMeta();
        Object[] pipelineRow = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        int index = 0;
        pipelineRow[index++] = this.getPipeline().getExecutionStartDate();
        pipelineRow[index++] = this.loggingPhase;
        pipelineRow[index++] = workflowMeta.getName();
        pipelineRow[index++] = workflowMeta.getFilename();
        pipelineRow[index++] = this.loggingWorkflow.getExecutionStartDate();
        pipelineRow[index++] = this.loggingWorkflow.getExecutionEndDate();
        pipelineRow[index++] = this.loggingWorkflow.getLogChannelId();
        ILoggingObject parent = this.loggingWorkflow.getParent();
        pipelineRow[index++] = parent == null ? null : parent.getLogChannelId();
        pipelineRow[index++] = HopLogStore.getAppender().getBuffer(this.loggingWorkflow.getLogChannelId(), false).toString();
        Result result = this.loggingWorkflow.getResult();
        pipelineRow[index++] = result == null ? 0L : result.getNrErrors();
        pipelineRow[index++] = this.loggingWorkflow.getStatusDescription();
        int startIndex = index;
        List actionResults = this.loggingWorkflow.getActionResults();
        if (((WorkflowLoggingMeta)this.meta).isLoggingActionResults() && !actionResults.isEmpty()) {
            for (ActionResult actionResult : actionResults) {
                index = startIndex;
                result = actionResult.getResult();
                Object[] transformRow = RowDataUtil.createResizedCopy((Object[])pipelineRow, (int)outputRowMeta.size());
                transformRow[index++] = actionResult.getActionName();
                transformRow[index++] = result.getEntryNr();
                transformRow[index++] = result.isResult();
                transformRow[index++] = actionResult.getLogChannelId();
                transformRow[index++] = HopLogStore.getAppender().getBuffer(actionResult.getLogChannelId(), false).toString();
                transformRow[index++] = result.getNrErrors();
                transformRow[index++] = actionResult.getLogDate();
                transformRow[index++] = result.getElapsedTimeMillis();
                transformRow[index++] = (long)result.getExitStatus();
                transformRow[index++] = result.getNrFilesRetrieved();
                transformRow[index++] = actionResult.getActionFilename();
                transformRow[index++] = actionResult.getComment();
                transformRow[index] = actionResult.getReason();
                this.putRow((IRowMeta)outputRowMeta, transformRow);
            }
        } else {
            this.putRow((IRowMeta)outputRowMeta, pipelineRow);
        }
        this.setOutputDone();
        return false;
    }

    @Generated
    public IWorkflowEngine<WorkflowMeta> getLoggingWorkflow() {
        return this.loggingWorkflow;
    }

    @Generated
    public void setLoggingWorkflow(IWorkflowEngine<WorkflowMeta> loggingWorkflow) {
        this.loggingWorkflow = loggingWorkflow;
    }

    @Generated
    public String getLoggingPhase() {
        return this.loggingPhase;
    }

    @Generated
    public void setLoggingPhase(String loggingPhase) {
        this.loggingPhase = loggingPhase;
    }
}

