/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.SchemaFormatter;
import org.apache.avro.SchemaFormatterFactoryConstants;

public interface SchemaFormatterFactory {
    default public String formatName() {
        String simpleName = this.getClass().getSimpleName();
        Matcher matcher = SchemaFormatterFactoryConstants.SIMPLE_NAME_PATTERN.matcher(simpleName);
        if (matcher.matches()) {
            return matcher.group(1).toLowerCase(Locale.ROOT);
        }
        throw new AvroRuntimeException("Formatter is not named \"<format>SchemaFormatterFactory\"; cannot determine format name.");
    }

    public SchemaFormatter getDefaultFormatter();

    default public SchemaFormatter getFormatterForVariant(String variantName) {
        throw new AvroRuntimeException("The schema format \"" + this.formatName() + "\" has no variants.");
    }
}

