/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import java.io.IOException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadIdResponseInterceptor
implements HttpResponseInterceptor {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(UploadIdResponseInterceptor.class);
    private static final @UnknownKeyFor @NonNull @Initialized String UPLOAD_ID_PARAM = "upload_id";
    private static final @UnknownKeyFor @NonNull @Initialized String UPLOAD_TYPE_PARAM = "uploadType";
    private static final @UnknownKeyFor @NonNull @Initialized String UPLOAD_HEADER = "X-GUploader-UploadID";

    public void interceptResponse(@UnknownKeyFor @NonNull @Initialized HttpResponse response) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        String uploadId = response.getHeaders().getFirstHeaderStringValue(UPLOAD_HEADER);
        if (uploadId == null) {
            return;
        }
        GenericUrl url = response.getRequest().getUrl();
        if (url.get((Object)UPLOAD_ID_PARAM) == null && url.get((Object)UPLOAD_TYPE_PARAM) != null) {
            LOG.debug("Upload ID for url {} on worker {} is {}", new Object[]{url, System.getProperty("worker_id"), uploadId});
        }
    }
}

