SELECT 'Upgrading MetaStore schema from 2.0.0 to 2.1.0' AS MESSAGE;

--:r 019-HIVE-13076.mssql.sql
CREATE TABLE KEY_CONSTRAINTS
(
  CHILD_CD_ID BIGINT,
  CHILD_INTEGER_IDX INT,
  CHILD_TBL_ID BIGINT,
  PARENT_CD_ID BIGINT NOT NULL,
  PARENT_INTEGER_IDX INT NOT NULL,
  PARENT_TBL_ID BIGINT NOT NULL,
  POSITION INT NOT NULL,
  CONSTRAINT_NAME VARCHAR(400) NOT NULL,
  CONSTRAINT_TYPE SMALLINT NOT NULL,
  UPDATE_RULE SMALLINT,
  DELETE_RULE SMALLINT,
  ENABLE_VALIDATE_RELY SMALLINT NOT NULL
) ;
ALTER TABLE KEY_CONSTRAINTS ADD CONSTRAINT CONSTRAINTS_PK PRIMARY KEY (CONSTRAINT_NAME, POSITION);
CREATE INDEX CONSTRAINTS_PARENT_TBL_ID__INDEX ON KEY_CONSTRAINTS(PARENT_TBL_ID);

--:r 020-HIVE-13395.mssql.sql
CREATE TABLE WRITE_SET (
  WS_DATABASE nvarchar(128) NOT NULL,
  WS_TABLE nvarchar(128) NOT NULL,
  WS_PARTITION nvarchar(767),
  WS_TXNID bigint NOT NULL,
  WS_COMMIT_ID bigint NOT NULL,
  WS_OPERATION_TYPE char(1) NOT NULL
);
ALTER TABLE TXN_COMPONENTS ADD TC_OPERATION_TYPE char(1) NOT NULL;

--:r 021-HIVE-13354.mssql.sql
ALTER TABLE COMPACTION_QUEUE ADD CQ_TBLPROPERTIES nvarchar(2048) NULL;
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_TBLPROPERTIES nvarchar(2048) NULL;


UPDATE VERSION SET SCHEMA_VERSION='2.1.0', VERSION_COMMENT='Hive release version 2.1.0' where VER_ID=1;
SELECT 'Finished upgrading MetaStore schema from 2.0.0 to 2.1.0' AS MESSAGE;
