/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class SerializableMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -3377238354349859240L;
    private final Map<K, V> copiedMap;
    private volatile transient Map<K, V> immutableMap;

    SerializableMap() {
        this.copiedMap = Maps.newHashMap();
    }

    private SerializableMap(Map<K, V> map) {
        this.copiedMap = Maps.newHashMap();
        this.copiedMap.putAll(map);
    }

    private SerializableMap(Map<K, V> map, Set<K> keys) {
        HashMap<K, V> filteredMap = Maps.newHashMapWithExpectedSize(keys.size());
        for (K key : keys) {
            if (!map.containsKey(key)) continue;
            filteredMap.put(key, map.get(key));
        }
        this.copiedMap = filteredMap;
    }

    public static <K, V> SerializableMap<K, V> copyOf(Map<K, V> map) {
        return map == null ? null : new SerializableMap<K, V>(map);
    }

    public static <K, V> SerializableMap<K, V> filteredCopyOf(Map<K, V> map, Set<K> keys) {
        return map == null ? null : new SerializableMap<K, V>(map, keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> immutableMap() {
        if (this.immutableMap == null) {
            SerializableMap serializableMap = this;
            synchronized (serializableMap) {
                if (this.immutableMap == null) {
                    this.immutableMap = Collections.unmodifiableMap(this.copiedMap);
                }
            }
        }
        return this.immutableMap;
    }

    @Override
    public int size() {
        return this.copiedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.copiedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.copiedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.copiedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.copiedMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.copiedMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.copiedMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.copiedMap.putAll(m);
    }

    @Override
    public void clear() {
        this.copiedMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.copiedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.copiedMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.copiedMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.copiedMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.copiedMap.hashCode();
    }
}

