/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.iceberg.transforms.Transforms;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.SerializableFunction;

@Description(name="iceberg_month", value="_FUNC_(value) - Returns the bucket value calculated by Iceberg month transform function ", extended="Example:\n  > SELECT _FUNC_('2023-01-01');\n  1")
public class GenericUDFIcebergMonth
extends GenericUDF {
    private final IntWritable result = new IntWritable();
    private transient PrimitiveObjectInspector argumentOI;
    private transient ObjectInspectorConverters.Converter converter;
    private transient UDFEvalFunction<GenericUDF.DeferredObject> evaluator;

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("ICEBERG_MONTH requires 1 arguments (value), but got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("ICEBERG_MONTH first argument takes primitive types, got " + this.argumentOI.getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        PrimitiveObjectInspector.PrimitiveCategory inputType = this.argumentOI.getPrimitiveCategory();
        switch (inputType) {
            case DATE: {
                this.converter = new PrimitiveObjectInspectorConverter.DateConverter(this.argumentOI, (SettableDateObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
                SerializableFunction dateTransform = Transforms.month().bind(Types.DateType.get());
                this.evaluator = arg -> {
                    DateWritableV2 val = (DateWritableV2)this.converter.convert(arg.get());
                    this.result.set(((Integer)dateTransform.apply(val.getDays())).intValue());
                };
                break;
            }
            case TIMESTAMP: {
                this.converter = new PrimitiveObjectInspectorConverter.TimestampConverter(this.argumentOI, (SettableTimestampObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
                SerializableFunction timestampTransform = Transforms.month().bind(Types.TimestampType.withoutZone());
                this.evaluator = arg -> {
                    TimestampWritableV2 val = (TimestampWritableV2)this.converter.convert(arg.get());
                    this.result.set(((Integer)timestampTransform.apply((Integer)Double.valueOf(val.getMicros()).longValue())).intValue());
                };
                break;
            }
            case TIMESTAMPLOCALTZ: {
                this.converter = new PrimitiveObjectInspectorConverter.TimestampLocalTZConverter(this.argumentOI, (SettableTimestampLocalTZObjectInspector)PrimitiveObjectInspectorFactory.writableTimestampTZObjectInspector);
                SerializableFunction timestampLocalTzTransform = Transforms.month().bind(Types.TimestampType.withZone());
                this.evaluator = arg -> {
                    TimestampLocalTZWritable val = (TimestampLocalTZWritable)this.converter.convert(arg.get());
                    this.result.set(((Integer)timestampLocalTzTransform.apply((Integer)Double.valueOf(val.getMicros()).longValue())).intValue());
                };
                break;
            }
            default: {
                throw new UDFArgumentException(" ICEBERG_MONTH() only takes DATE/TIMESTAMP/TIMESTAMPLOCALTZ types as first argument, got " + String.valueOf(inputType));
            }
        }
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        GenericUDF.DeferredObject argument = arguments[0];
        if (argument == null || argument.get() == null) {
            return null;
        }
        this.evaluator.apply(argument);
        return this.result;
    }

    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("iceberg_month", children);
    }

    @FunctionalInterface
    private static interface UDFEvalFunction<T> {
        public void apply(T var1) throws HiveException;
    }
}

