/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.metastore.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.NoMutex;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.Table;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHouseKeeperService
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergHouseKeeperService.class);
    private Configuration conf;
    private TxnStore txnHandler;
    private boolean shouldUseMutex;
    private ExecutorService deleteExecutorService = null;

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ICEBERG_TABLE_EXPIRY_INTERVAL, (TimeUnit)unit);
    }

    public void run() {
        LOG.debug("Running IcebergHouseKeeperService...");
        String catalogName = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ICEBERG_TABLE_EXPIRY_CATALOG_NAME);
        String dbPattern = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ICEBERG_TABLE_EXPIRY_DATABASE_PATTERN);
        String tablePattern = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ICEBERG_TABLE_EXPIRY_TABLE_PATTERN);
        NoMutex mutex = this.shouldUseMutex ? this.txnHandler.getMutexAPI() : new NoMutex();
        try (TxnStore.MutexAPI.LockHandle closeable = mutex.acquireLock(TxnStore.MUTEX_KEY.IcebergHouseKeeper.name());){
            this.expireTables(catalogName, dbPattern, tablePattern);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void expireTables(String catalogName, String dbPattern, String tablePattern) {
        try (HiveMetaStoreClient msc = new HiveMetaStoreClient(this.conf);){
            int maxBatchSize = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX);
            Iterable tables = IcebergTableUtil.getTableFetcher((IMetaStoreClient)msc, catalogName, dbPattern, tablePattern).getTables(maxBatchSize);
            for (org.apache.hadoop.hive.metastore.api.Table table : tables) {
                this.expireSnapshotsForTable(IcebergTableUtil.getTable(this.conf, table));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting tables from metastore", e);
        }
    }

    private void expireSnapshotsForTable(Table icebergTable) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        if (this.deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(this.deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    public void enforceMutex(boolean enableMutex) {
        this.shouldUseMutex = enableMutex;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore((Configuration)this.conf);
        int numThreads = this.conf.getInt(HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.varname, HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.defaultIntVal);
        if (numThreads > 0) {
            LOG.info("Will expire Iceberg snapshots using an executor service with {} threads", (Object)numThreads);
            this.deleteExecutorService = IcebergTableUtil.newDeleteThreadPool("iceberg-housekeeper-service", numThreads);
        }
    }
}

