/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metasummary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.hadoop.hive.metastore.metasummary.MetadataTableSummary;
import org.apache.hadoop.hive.metastore.metasummary.SummaryMapBuilder;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.metasummary.IcebergSummaryRetriever;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataSummary
extends IcebergSummaryRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataSummary.class);
    public static final String SNAPSHOT_MAX_AGE = "snapshotMaxAge";
    public static final String SNAPSHOT_MIN_KEEP = "snapshotMinKeep";
    public static final String NUM_SNAPSHOTS = "numSnapshots";
    public static final String NUM_MANIFESTS = "numManifests";
    public static final String NUM_METADATA_FILES = "numMetadataFiles";
    public static final String MANIFESTS_SIZE = "manifestsSize";
    public static final String NUM_BRANCHES = "numBranches";
    public static final String NUM_TAGS = "numTags";

    @Override
    public List<String> getFieldNames() {
        if (this.formatJson) {
            return Collections.singletonList("metadata");
        }
        return Arrays.asList(NUM_SNAPSHOTS, NUM_METADATA_FILES, NUM_MANIFESTS, MANIFESTS_SIZE, SNAPSHOT_MAX_AGE, SNAPSHOT_MIN_KEEP, NUM_BRANCHES, NUM_TAGS);
    }

    @Override
    public void getMetaSummary(Table table, MetadataTableSummary metaSummary) {
        this.basicMetadataSummary(table, metaSummary);
        SummaryMapBuilder builder = new SummaryMapBuilder();
        Table metadataEntries = MetadataTableUtils.createMetadataTableInstance(table, MetadataTableType.METADATA_LOG_ENTRIES);
        try (CloseableIterable iterable = metadataEntries.newBatchScan().planFiles();){
            ArrayList<DataFile> files = Lists.newArrayList(CloseableIterable.transform(iterable, t -> (DataFile)((FileScanTask)t).file()));
            builder.add(NUM_METADATA_FILES, (Object)files.size());
        }
        catch (IOException e) {
            LOG.warn("Error while listing the metadata files, table: " + table.name(), (Throwable)e);
            builder.add(NUM_METADATA_FILES, (Object)1);
        }
        int numManifests = 0;
        long manifestsSize = 0L;
        if (table.currentSnapshot() != null) {
            List<ManifestFile> manifests = table.currentSnapshot().allManifests(table.io());
            numManifests = manifests.size();
            manifestsSize = manifests.stream().map(ManifestFile::length).mapToLong(Long::longValue).sum();
        }
        this.branchOrTagSummary(table, builder);
        Map<String, String> properties = table.properties();
        builder.add(NUM_SNAPSHOTS, (Object)Integer.parseInt(properties.getOrDefault("snapshot-count", "" + IteratorUtils.size(table.snapshots().iterator())))).add(NUM_MANIFESTS, (Object)numManifests).add(MANIFESTS_SIZE, (Object)manifestsSize).add(SNAPSHOT_MAX_AGE, (Object)Long.parseLong(properties.getOrDefault("history.expire.max-snapshot-age-ms", "-1"))).add(SNAPSHOT_MIN_KEEP, (Object)Long.parseLong(properties.getOrDefault("history.expire.min-snapshots-to-keep", "-1")));
        if (this.formatJson) {
            metaSummary.addExtra("metadata", builder);
        } else {
            metaSummary.addExtra(builder);
        }
    }

    private void basicMetadataSummary(Table table, MetadataTableSummary metaSummary) {
        Map<String, String> summary = table.currentSnapshot().summary();
        metaSummary.setNumRows(Long.parseLong(summary.getOrDefault("total-records", "0")));
        metaSummary.setTotalSize(Long.parseLong(summary.getOrDefault("total-files-size", "0")));
        metaSummary.setPartitionColumnCount(table.spec().fields().size());
        metaSummary.setNumFiles(Long.parseLong(summary.getOrDefault("total-data-files", "0")));
        List<Types.NestedField> columns = table.schema().columns();
        metaSummary.columnSummary(columns.size(), (int)columns.stream().filter(col -> col.type().isListType()).count(), (int)columns.stream().filter(col -> col.type().isStructType()).count(), (int)columns.stream().filter(col -> col.type().isMapType()).count());
        if (table.spec().isPartitioned()) {
            PartitionsTable partitionsTable = (PartitionsTable)MetadataTableUtils.createMetadataTableInstance(table, MetadataTableType.PARTITIONS);
            try (CloseableIterable iterable = partitionsTable.newScan().planFiles();){
                long partitionCount = 0L;
                for (FileScanTask fileScanTask : iterable) {
                    partitionCount += ((DataFile)fileScanTask.file()).recordCount();
                }
                metaSummary.setPartitionCount((int)partitionCount);
            }
            catch (Exception e) {
                LOG.warn("Error listing the partitions in table: " + table.name(), (Throwable)e);
                metaSummary.setPartitionCount(0);
            }
        }
    }

    private void branchOrTagSummary(Table table, SummaryMapBuilder builder) {
        Map<String, SnapshotRef> refs = table.refs();
        AtomicInteger numBranches = new AtomicInteger(0);
        AtomicInteger numTags = new AtomicInteger(0);
        if (refs != null) {
            refs.forEach((key, value) -> {
                if (value.isBranch()) {
                    numBranches.getAndIncrement();
                } else {
                    numTags.getAndIncrement();
                }
            });
        }
        builder.add(NUM_BRANCHES, (Object)numBranches.get()).add(NUM_TAGS, (Object)numTags.get());
    }
}

