/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.data.BaseDeleteLoader;
import org.apache.iceberg.io.InputFile;

public class CachingDeleteLoader
extends BaseDeleteLoader {
    private final ObjectCache cache;

    public CachingDeleteLoader(Function<DeleteFile, InputFile> loadInputFile, Configuration conf) {
        super(loadInputFile);
        String queryId = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID);
        this.cache = ObjectCacheFactory.getCache((Configuration)conf, (String)queryId, (boolean)false);
    }

    @Override
    protected boolean canCache(long size) {
        return this.cache != null;
    }

    @Override
    protected <V> V getOrLoad(String key, Supplier<V> valueSupplier, long valueSize) {
        try {
            return (V)this.cache.retrieve(key, valueSupplier::get);
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
    }
}

