/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hive.iceberg.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.actions.BaseRewritePositionalDeleteFiles;
import org.apache.iceberg.actions.RewritePositionDeleteFiles;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BaseRewritePositionalDeleteFiles", generator="Immutables")
public final class ImmutableRewritePositionDeleteFiles {
    private ImmutableRewritePositionDeleteFiles() {
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @CheckReturnValue
    @Generated(from="BaseRewritePositionalDeleteFiles.FileGroupInfo", generator="Immutables")
    @Immutable
    public static final class FileGroupInfo
    implements BaseRewritePositionalDeleteFiles.FileGroupInfo {
        private final int globalIndex;
        private final int partitionIndex;
        private final StructLike partition;

        private FileGroupInfo(int globalIndex, int partitionIndex, StructLike partition) {
            this.globalIndex = globalIndex;
            this.partitionIndex = partitionIndex;
            this.partition = partition;
        }

        @Override
        public int globalIndex() {
            return this.globalIndex;
        }

        @Override
        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public StructLike partition() {
            return this.partition;
        }

        public final FileGroupInfo withGlobalIndex(int value) {
            if (this.globalIndex == value) {
                return this;
            }
            return new FileGroupInfo(value, this.partitionIndex, this.partition);
        }

        public final FileGroupInfo withPartitionIndex(int value) {
            if (this.partitionIndex == value) {
                return this;
            }
            return new FileGroupInfo(this.globalIndex, value, this.partition);
        }

        public final FileGroupInfo withPartition(StructLike value) {
            if (this.partition == value) {
                return this;
            }
            StructLike newValue = Objects.requireNonNull(value, "partition");
            return new FileGroupInfo(this.globalIndex, this.partitionIndex, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupInfo && this.equalTo(0, (FileGroupInfo)another);
        }

        private boolean equalTo(int synthetic, FileGroupInfo another) {
            return this.globalIndex == another.globalIndex && this.partitionIndex == another.partitionIndex && this.partition.equals(another.partition);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.globalIndex;
            h += (h << 5) + this.partitionIndex;
            h += (h << 5) + this.partition.hashCode();
            return h;
        }

        public String toString() {
            return "FileGroupInfo{globalIndex=" + this.globalIndex + ", partitionIndex=" + this.partitionIndex + ", partition=" + this.partition + "}";
        }

        public static FileGroupInfo copyOf(BaseRewritePositionalDeleteFiles.FileGroupInfo instance) {
            if (instance instanceof FileGroupInfo) {
                return (FileGroupInfo)instance;
            }
            return FileGroupInfo.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewritePositionalDeleteFiles.FileGroupInfo", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_GLOBAL_INDEX = 1L;
            private static final long INIT_BIT_PARTITION_INDEX = 2L;
            private static final long INIT_BIT_PARTITION = 4L;
            private long initBits = 7L;
            private int globalIndex;
            private int partitionIndex;
            @Nullable
            private StructLike partition;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewritePositionalDeleteFiles.FileGroupInfo instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewritePositionDeleteFiles.FileGroupInfo instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewritePositionDeleteFiles.FileGroupInfo instance;
                long bits = 0L;
                if (object instanceof BaseRewritePositionalDeleteFiles.FileGroupInfo) {
                    instance = (BaseRewritePositionalDeleteFiles.FileGroupInfo)object;
                    if ((bits & 1L) == 0L) {
                        this.partitionIndex(instance.partitionIndex());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.globalIndex(instance.globalIndex());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 4L;
                    }
                }
                if (object instanceof RewritePositionDeleteFiles.FileGroupInfo) {
                    instance = (RewritePositionDeleteFiles.FileGroupInfo)object;
                    if ((bits & 1L) == 0L) {
                        this.partitionIndex(instance.partitionIndex());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.globalIndex(instance.globalIndex());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.partition(instance.partition());
                        bits |= 4L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder globalIndex(int globalIndex) {
                this.globalIndex = globalIndex;
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partitionIndex(int partitionIndex) {
                this.partitionIndex = partitionIndex;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder partition(StructLike partition) {
                this.partition = Objects.requireNonNull(partition, "partition");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public FileGroupInfo build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupInfo(this.globalIndex, this.partitionIndex, this.partition);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("globalIndex");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("partitionIndex");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("partition");
                }
                return "Cannot build FileGroupInfo, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewritePositionalDeleteFiles.FileGroupRewriteResult", generator="Immutables")
    @Immutable
    public static final class FileGroupRewriteResult
    implements BaseRewritePositionalDeleteFiles.FileGroupRewriteResult {
        private final RewritePositionDeleteFiles.FileGroupInfo info;
        private final int rewrittenDeleteFilesCount;
        private final int addedDeleteFilesCount;
        private final long rewrittenBytesCount;
        private final long addedBytesCount;

        private FileGroupRewriteResult(RewritePositionDeleteFiles.FileGroupInfo info, int rewrittenDeleteFilesCount, int addedDeleteFilesCount, long rewrittenBytesCount, long addedBytesCount) {
            this.info = info;
            this.rewrittenDeleteFilesCount = rewrittenDeleteFilesCount;
            this.addedDeleteFilesCount = addedDeleteFilesCount;
            this.rewrittenBytesCount = rewrittenBytesCount;
            this.addedBytesCount = addedBytesCount;
        }

        @Override
        public RewritePositionDeleteFiles.FileGroupInfo info() {
            return this.info;
        }

        @Override
        public int rewrittenDeleteFilesCount() {
            return this.rewrittenDeleteFilesCount;
        }

        @Override
        public int addedDeleteFilesCount() {
            return this.addedDeleteFilesCount;
        }

        @Override
        public long rewrittenBytesCount() {
            return this.rewrittenBytesCount;
        }

        @Override
        public long addedBytesCount() {
            return this.addedBytesCount;
        }

        public final FileGroupRewriteResult withInfo(RewritePositionDeleteFiles.FileGroupInfo value) {
            if (this.info == value) {
                return this;
            }
            RewritePositionDeleteFiles.FileGroupInfo newValue = Objects.requireNonNull(value, "info");
            return new FileGroupRewriteResult(newValue, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final FileGroupRewriteResult withRewrittenDeleteFilesCount(int value) {
            if (this.rewrittenDeleteFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, value, this.addedDeleteFilesCount, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final FileGroupRewriteResult withAddedDeleteFilesCount(int value) {
            if (this.addedDeleteFilesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.rewrittenDeleteFilesCount, value, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final FileGroupRewriteResult withRewrittenBytesCount(long value) {
            if (this.rewrittenBytesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, value, this.addedBytesCount);
        }

        public final FileGroupRewriteResult withAddedBytesCount(long value) {
            if (this.addedBytesCount == value) {
                return this;
            }
            return new FileGroupRewriteResult(this.info, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, this.rewrittenBytesCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileGroupRewriteResult && this.equalTo(0, (FileGroupRewriteResult)another);
        }

        private boolean equalTo(int synthetic, FileGroupRewriteResult another) {
            return this.info.equals(another.info) && this.rewrittenDeleteFilesCount == another.rewrittenDeleteFilesCount && this.addedDeleteFilesCount == another.addedDeleteFilesCount && this.rewrittenBytesCount == another.rewrittenBytesCount && this.addedBytesCount == another.addedBytesCount;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.info.hashCode();
            h += (h << 5) + this.rewrittenDeleteFilesCount;
            h += (h << 5) + this.addedDeleteFilesCount;
            h += (h << 5) + Long.hashCode(this.rewrittenBytesCount);
            h += (h << 5) + Long.hashCode(this.addedBytesCount);
            return h;
        }

        public String toString() {
            return "FileGroupRewriteResult{info=" + this.info + ", rewrittenDeleteFilesCount=" + this.rewrittenDeleteFilesCount + ", addedDeleteFilesCount=" + this.addedDeleteFilesCount + ", rewrittenBytesCount=" + this.rewrittenBytesCount + ", addedBytesCount=" + this.addedBytesCount + "}";
        }

        public static FileGroupRewriteResult copyOf(BaseRewritePositionalDeleteFiles.FileGroupRewriteResult instance) {
            if (instance instanceof FileGroupRewriteResult) {
                return (FileGroupRewriteResult)instance;
            }
            return FileGroupRewriteResult.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewritePositionalDeleteFiles.FileGroupRewriteResult", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_INFO = 1L;
            private static final long INIT_BIT_REWRITTEN_DELETE_FILES_COUNT = 2L;
            private static final long INIT_BIT_ADDED_DELETE_FILES_COUNT = 4L;
            private static final long INIT_BIT_REWRITTEN_BYTES_COUNT = 8L;
            private static final long INIT_BIT_ADDED_BYTES_COUNT = 16L;
            private long initBits = 31L;
            @Nullable
            private RewritePositionDeleteFiles.FileGroupInfo info;
            private int rewrittenDeleteFilesCount;
            private int addedDeleteFilesCount;
            private long rewrittenBytesCount;
            private long addedBytesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewritePositionalDeleteFiles.FileGroupRewriteResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(RewritePositionDeleteFiles.FileGroupRewriteResult instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewritePositionDeleteFiles.FileGroupRewriteResult instance;
                long bits = 0L;
                if (object instanceof BaseRewritePositionalDeleteFiles.FileGroupRewriteResult) {
                    instance = (BaseRewritePositionalDeleteFiles.FileGroupRewriteResult)object;
                    if ((bits & 4L) == 0L) {
                        this.rewrittenDeleteFilesCount(instance.rewrittenDeleteFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.addedBytesCount(instance.addedBytesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addedDeleteFilesCount(instance.addedDeleteFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.info(instance.info());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof RewritePositionDeleteFiles.FileGroupRewriteResult) {
                    instance = (RewritePositionDeleteFiles.FileGroupRewriteResult)object;
                    if ((bits & 4L) == 0L) {
                        this.rewrittenDeleteFilesCount(instance.rewrittenDeleteFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.addedBytesCount(instance.addedBytesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addedDeleteFilesCount(instance.addedDeleteFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.info(instance.info());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x10L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder info(RewritePositionDeleteFiles.FileGroupInfo info) {
                this.info = Objects.requireNonNull(info, "info");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenDeleteFilesCount(int rewrittenDeleteFilesCount) {
                this.rewrittenDeleteFilesCount = rewrittenDeleteFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedDeleteFilesCount(int addedDeleteFilesCount) {
                this.addedDeleteFilesCount = addedDeleteFilesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedBytesCount(long addedBytesCount) {
                this.addedBytesCount = addedBytesCount;
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            public FileGroupRewriteResult build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileGroupRewriteResult(this.info, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, this.rewrittenBytesCount, this.addedBytesCount);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("info");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("rewrittenDeleteFilesCount");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("addedDeleteFilesCount");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("rewrittenBytesCount");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("addedBytesCount");
                }
                return "Cannot build FileGroupRewriteResult, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="BaseRewritePositionalDeleteFiles.Result", generator="Immutables")
    @Immutable
    public static final class Result
    implements BaseRewritePositionalDeleteFiles.Result {
        private final List<RewritePositionDeleteFiles.FileGroupRewriteResult> rewriteResults;
        private final int rewrittenDeleteFilesCount;
        private final int addedDeleteFilesCount;
        private final long rewrittenBytesCount;
        private final long addedBytesCount;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Result(Builder builder) {
            this.rewriteResults = ImmutableRewritePositionDeleteFiles.createUnmodifiableList(true, builder.rewriteResults);
            if (builder.rewrittenDeleteFilesCountIsSet()) {
                this.initShim.rewrittenDeleteFilesCount(builder.rewrittenDeleteFilesCount);
            }
            if (builder.addedDeleteFilesCountIsSet()) {
                this.initShim.addedDeleteFilesCount(builder.addedDeleteFilesCount);
            }
            if (builder.rewrittenBytesCountIsSet()) {
                this.initShim.rewrittenBytesCount(builder.rewrittenBytesCount);
            }
            if (builder.addedBytesCountIsSet()) {
                this.initShim.addedBytesCount(builder.addedBytesCount);
            }
            this.rewrittenDeleteFilesCount = this.initShim.rewrittenDeleteFilesCount();
            this.addedDeleteFilesCount = this.initShim.addedDeleteFilesCount();
            this.rewrittenBytesCount = this.initShim.rewrittenBytesCount();
            this.addedBytesCount = this.initShim.addedBytesCount();
            this.initShim = null;
        }

        private Result(List<RewritePositionDeleteFiles.FileGroupRewriteResult> rewriteResults, int rewrittenDeleteFilesCount, int addedDeleteFilesCount, long rewrittenBytesCount, long addedBytesCount) {
            this.rewriteResults = rewriteResults;
            this.rewrittenDeleteFilesCount = rewrittenDeleteFilesCount;
            this.addedDeleteFilesCount = addedDeleteFilesCount;
            this.rewrittenBytesCount = rewrittenBytesCount;
            this.addedBytesCount = addedBytesCount;
            this.initShim = null;
        }

        private int rewrittenDeleteFilesCountInitialize() {
            return BaseRewritePositionalDeleteFiles.Result.super.rewrittenDeleteFilesCount();
        }

        private int addedDeleteFilesCountInitialize() {
            return BaseRewritePositionalDeleteFiles.Result.super.addedDeleteFilesCount();
        }

        private long rewrittenBytesCountInitialize() {
            return BaseRewritePositionalDeleteFiles.Result.super.rewrittenBytesCount();
        }

        private long addedBytesCountInitialize() {
            return BaseRewritePositionalDeleteFiles.Result.super.addedBytesCount();
        }

        @Override
        public List<RewritePositionDeleteFiles.FileGroupRewriteResult> rewriteResults() {
            return this.rewriteResults;
        }

        @Override
        public int rewrittenDeleteFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenDeleteFilesCount() : this.rewrittenDeleteFilesCount;
        }

        @Override
        public int addedDeleteFilesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.addedDeleteFilesCount() : this.addedDeleteFilesCount;
        }

        @Override
        public long rewrittenBytesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.rewrittenBytesCount() : this.rewrittenBytesCount;
        }

        @Override
        public long addedBytesCount() {
            InitShim shim = this.initShim;
            return shim != null ? shim.addedBytesCount() : this.addedBytesCount;
        }

        public final Result withRewriteResults(RewritePositionDeleteFiles.FileGroupRewriteResult ... elements) {
            List<RewritePositionDeleteFiles.FileGroupRewriteResult> newValue = ImmutableRewritePositionDeleteFiles.createUnmodifiableList(false, ImmutableRewritePositionDeleteFiles.createSafeList(Arrays.asList(elements), true, false));
            return new Result(newValue, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final Result withRewriteResults(Iterable<? extends RewritePositionDeleteFiles.FileGroupRewriteResult> elements) {
            if (this.rewriteResults == elements) {
                return this;
            }
            List<RewritePositionDeleteFiles.FileGroupRewriteResult> newValue = ImmutableRewritePositionDeleteFiles.createUnmodifiableList(false, ImmutableRewritePositionDeleteFiles.createSafeList(elements, true, false));
            return new Result(newValue, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final Result withRewrittenDeleteFilesCount(int value) {
            if (this.rewrittenDeleteFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, value, this.addedDeleteFilesCount, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final Result withAddedDeleteFilesCount(int value) {
            if (this.addedDeleteFilesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewrittenDeleteFilesCount, value, this.rewrittenBytesCount, this.addedBytesCount);
        }

        public final Result withRewrittenBytesCount(long value) {
            if (this.rewrittenBytesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, value, this.addedBytesCount);
        }

        public final Result withAddedBytesCount(long value) {
            if (this.addedBytesCount == value) {
                return this;
            }
            return new Result(this.rewriteResults, this.rewrittenDeleteFilesCount, this.addedDeleteFilesCount, this.rewrittenBytesCount, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Result && this.equalTo(0, (Result)another);
        }

        private boolean equalTo(int synthetic, Result another) {
            return this.rewriteResults.equals(another.rewriteResults) && this.rewrittenDeleteFilesCount == another.rewrittenDeleteFilesCount && this.addedDeleteFilesCount == another.addedDeleteFilesCount && this.rewrittenBytesCount == another.rewrittenBytesCount && this.addedBytesCount == another.addedBytesCount;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.rewriteResults.hashCode();
            h += (h << 5) + this.rewrittenDeleteFilesCount;
            h += (h << 5) + this.addedDeleteFilesCount;
            h += (h << 5) + Long.hashCode(this.rewrittenBytesCount);
            h += (h << 5) + Long.hashCode(this.addedBytesCount);
            return h;
        }

        public String toString() {
            return "Result{rewriteResults=" + this.rewriteResults + ", rewrittenDeleteFilesCount=" + this.rewrittenDeleteFilesCount + ", addedDeleteFilesCount=" + this.addedDeleteFilesCount + ", rewrittenBytesCount=" + this.rewrittenBytesCount + ", addedBytesCount=" + this.addedBytesCount + "}";
        }

        public static Result copyOf(BaseRewritePositionalDeleteFiles.Result instance) {
            if (instance instanceof Result) {
                return (Result)instance;
            }
            return Result.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="BaseRewritePositionalDeleteFiles.Result", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_REWRITTEN_DELETE_FILES_COUNT = 1L;
            private static final long OPT_BIT_ADDED_DELETE_FILES_COUNT = 2L;
            private static final long OPT_BIT_REWRITTEN_BYTES_COUNT = 4L;
            private static final long OPT_BIT_ADDED_BYTES_COUNT = 8L;
            private long optBits;
            private List<RewritePositionDeleteFiles.FileGroupRewriteResult> rewriteResults = new ArrayList<RewritePositionDeleteFiles.FileGroupRewriteResult>();
            private int rewrittenDeleteFilesCount;
            private int addedDeleteFilesCount;
            private long rewrittenBytesCount;
            private long addedBytesCount;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RewritePositionDeleteFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(BaseRewritePositionalDeleteFiles.Result instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((short)0, instance);
                return this;
            }

            private void from(short _unused, Object object) {
                RewritePositionDeleteFiles.Result instance;
                long bits = 0L;
                if (object instanceof RewritePositionDeleteFiles.Result) {
                    instance = (RewritePositionDeleteFiles.Result)object;
                    if ((bits & 4L) == 0L) {
                        this.rewrittenDeleteFilesCount(instance.rewrittenDeleteFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.addedBytesCount(instance.addedBytesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addedDeleteFilesCount(instance.addedDeleteFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.addAllRewriteResults(instance.rewriteResults());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof BaseRewritePositionalDeleteFiles.Result) {
                    instance = (BaseRewritePositionalDeleteFiles.Result)object;
                    if ((bits & 4L) == 0L) {
                        this.rewrittenDeleteFilesCount(instance.rewrittenDeleteFilesCount());
                        bits |= 4L;
                    }
                    if ((bits & 1L) == 0L) {
                        this.addedBytesCount(instance.addedBytesCount());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.addedDeleteFilesCount(instance.addedDeleteFilesCount());
                        bits |= 2L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.addAllRewriteResults(instance.rewriteResults());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.rewrittenBytesCount(instance.rewrittenBytesCount());
                        bits |= 0x10L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteResults(RewritePositionDeleteFiles.FileGroupRewriteResult element) {
                this.rewriteResults.add(Objects.requireNonNull(element, "rewriteResults element"));
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addRewriteResults(RewritePositionDeleteFiles.FileGroupRewriteResult ... elements) {
                for (RewritePositionDeleteFiles.FileGroupRewriteResult element : elements) {
                    this.rewriteResults.add(Objects.requireNonNull(element, "rewriteResults element"));
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewriteResults(Iterable<? extends RewritePositionDeleteFiles.FileGroupRewriteResult> elements) {
                this.rewriteResults.clear();
                return this.addAllRewriteResults(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllRewriteResults(Iterable<? extends RewritePositionDeleteFiles.FileGroupRewriteResult> elements) {
                for (RewritePositionDeleteFiles.FileGroupRewriteResult fileGroupRewriteResult : elements) {
                    this.rewriteResults.add(Objects.requireNonNull(fileGroupRewriteResult, "rewriteResults element"));
                }
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenDeleteFilesCount(int rewrittenDeleteFilesCount) {
                this.rewrittenDeleteFilesCount = rewrittenDeleteFilesCount;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedDeleteFilesCount(int addedDeleteFilesCount) {
                this.addedDeleteFilesCount = addedDeleteFilesCount;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addedBytesCount(long addedBytesCount) {
                this.addedBytesCount = addedBytesCount;
                this.optBits |= 8L;
                return this;
            }

            public Result build() {
                return new Result(this);
            }

            private boolean rewrittenDeleteFilesCountIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean addedDeleteFilesCountIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean rewrittenBytesCountIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean addedBytesCountIsSet() {
                return (this.optBits & 8L) != 0L;
            }
        }

        @Generated(from="BaseRewritePositionalDeleteFiles.Result", generator="Immutables")
        private final class InitShim {
            private byte rewrittenDeleteFilesCountBuildStage = 0;
            private int rewrittenDeleteFilesCount;
            private byte addedDeleteFilesCountBuildStage = 0;
            private int addedDeleteFilesCount;
            private byte rewrittenBytesCountBuildStage = 0;
            private long rewrittenBytesCount;
            private byte addedBytesCountBuildStage = 0;
            private long addedBytesCount;

            private InitShim() {
            }

            int rewrittenDeleteFilesCount() {
                if (this.rewrittenDeleteFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenDeleteFilesCountBuildStage == 0) {
                    this.rewrittenDeleteFilesCountBuildStage = (byte)-1;
                    this.rewrittenDeleteFilesCount = Result.this.rewrittenDeleteFilesCountInitialize();
                    this.rewrittenDeleteFilesCountBuildStage = 1;
                }
                return this.rewrittenDeleteFilesCount;
            }

            void rewrittenDeleteFilesCount(int rewrittenDeleteFilesCount) {
                this.rewrittenDeleteFilesCount = rewrittenDeleteFilesCount;
                this.rewrittenDeleteFilesCountBuildStage = 1;
            }

            int addedDeleteFilesCount() {
                if (this.addedDeleteFilesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.addedDeleteFilesCountBuildStage == 0) {
                    this.addedDeleteFilesCountBuildStage = (byte)-1;
                    this.addedDeleteFilesCount = Result.this.addedDeleteFilesCountInitialize();
                    this.addedDeleteFilesCountBuildStage = 1;
                }
                return this.addedDeleteFilesCount;
            }

            void addedDeleteFilesCount(int addedDeleteFilesCount) {
                this.addedDeleteFilesCount = addedDeleteFilesCount;
                this.addedDeleteFilesCountBuildStage = 1;
            }

            long rewrittenBytesCount() {
                if (this.rewrittenBytesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.rewrittenBytesCountBuildStage == 0) {
                    this.rewrittenBytesCountBuildStage = (byte)-1;
                    this.rewrittenBytesCount = Result.this.rewrittenBytesCountInitialize();
                    this.rewrittenBytesCountBuildStage = 1;
                }
                return this.rewrittenBytesCount;
            }

            void rewrittenBytesCount(long rewrittenBytesCount) {
                this.rewrittenBytesCount = rewrittenBytesCount;
                this.rewrittenBytesCountBuildStage = 1;
            }

            long addedBytesCount() {
                if (this.addedBytesCountBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.addedBytesCountBuildStage == 0) {
                    this.addedBytesCountBuildStage = (byte)-1;
                    this.addedBytesCount = Result.this.addedBytesCountInitialize();
                    this.addedBytesCountBuildStage = 1;
                }
                return this.addedBytesCount;
            }

            void addedBytesCount(long addedBytesCount) {
                this.addedBytesCount = addedBytesCount;
                this.addedBytesCountBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.rewrittenDeleteFilesCountBuildStage == -1) {
                    attributes.add("rewrittenDeleteFilesCount");
                }
                if (this.addedDeleteFilesCountBuildStage == -1) {
                    attributes.add("addedDeleteFilesCount");
                }
                if (this.rewrittenBytesCountBuildStage == -1) {
                    attributes.add("rewrittenBytesCount");
                }
                if (this.addedBytesCountBuildStage == -1) {
                    attributes.add("addedBytesCount");
                }
                return "Cannot build Result, attribute initializers form cycle " + attributes;
            }
        }
    }
}

