/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class FilesTable
extends BaseFilesTable {
    FilesTable(Table table) {
        this(table, table.name() + ".files");
    }

    FilesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public TableScan newScan() {
        return new FilesTableScan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.FILES;
    }

    public static class FilesTableScan
    extends BaseFilesTable.BaseFilesTableScan {
        FilesTableScan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.FILES);
        }

        FilesTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.FILES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new FilesTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<ManifestFile> manifests() {
            return CloseableIterable.withNoopClose(this.snapshot().allManifests(this.table().io()));
        }
    }
}

