/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SnapshotScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.TableScanUtil;

abstract class BaseTableScan
extends SnapshotScan<TableScan, FileScanTask, CombinedScanTask>
implements TableScan {
    protected BaseTableScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    public TableScan appendsBetween(long fromSnapshotId, long toSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    @Override
    public TableScan appendsAfter(long fromSnapshotId) {
        throw new UnsupportedOperationException("Incremental scan is not supported");
    }

    @Override
    public CloseableIterable<CombinedScanTask> planTasks() {
        CloseableIterable<FileScanTask> fileScanTasks = this.planFiles();
        CloseableIterable<FileScanTask> splitFiles = TableScanUtil.splitFiles(fileScanTasks, this.targetSplitSize());
        return TableScanUtil.planTasks(splitFiles, this.targetSplitSize(), this.splitLookback(), this.splitOpenFileCost());
    }
}

