/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import org.apache.datasketches.hive.tuple.DataToSketchUDAF;
import org.apache.datasketches.hive.tuple.ObjectInspectorValidator;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

@Description(name="DataToDoubleSummarySketch", value="_FUNC_(key, double value, nominal number of entries, sampling probability)", extended="Returns a Sketch<DoubleSummary> as a binary blob that can be operated on by other tuple sketch related functions. The nominal number of entries is optional, must be a power of 2 and controls the relative error expected from the sketch. A number of 16384 can be expected to yield errors of roughly +-1.5% in the estimation of uniques. The default number is defined in the sketches-core library, and at the time of this writing was 4096 (about 3% error). The sampling probability is optional and must be from 0 to 1. The default is 1 (no sampling)")
public class DataToDoubleSummarySketchUDAF
extends DataToSketchUDAF {
    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        super.getEvaluator(info);
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[1], 1, PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
        return this.createEvaluator();
    }

    @Override
    public GenericUDAFEvaluator createEvaluator() {
        return new DataToDoubleSummarySketchEvaluator();
    }

    static class DataToDoubleSummarySketchEvaluator
    extends DataToSketchUDAF.DataToSketchEvaluator<Double, DoubleSummary> {
        private static final SummaryDeserializer<DoubleSummary> SUMMARY_DESERIALIZER = new DoubleSummaryDeserializer();
        private static final SummaryFactory<DoubleSummary> SUMMARY_FACTORY = new DoubleSummaryFactory(DoubleSummary.Mode.Sum);
        private static final SummarySetOperations<DoubleSummary> SUMMARY_SET_OPS = new DoubleSummarySetOperations(DoubleSummary.Mode.Sum);

        DataToDoubleSummarySketchEvaluator() {
        }

        @Override
        protected SummaryDeserializer<DoubleSummary> getSummaryDeserializer() {
            return SUMMARY_DESERIALIZER;
        }

        @Override
        protected SummaryFactory<DoubleSummary> getSummaryFactory(Object[] data) {
            return SUMMARY_FACTORY;
        }

        @Override
        protected SummarySetOperations<DoubleSummary> getSummarySetOperationsForIterate(Object[] data) {
            return null;
        }

        @Override
        protected SummarySetOperations<DoubleSummary> getSummarySetOperationsForMerge(Object data) {
            return SUMMARY_SET_OPS;
        }
    }
}

