/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.tuple;

import java.util.Arrays;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchEvaluator;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesSketchState;
import org.apache.datasketches.hive.tuple.ArrayOfDoublesUnionState;
import org.apache.datasketches.hive.tuple.ObjectInspectorValidator;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="DataToArrayOfDoublesSketch", value="_FUNC_(key, double param 1, ..., double param N, nominal number of entries, sampling probability)", extended="Returns an ArrayOfDoublesSketch as a binary blob that can be operated on by other ArrayOfDoublesSketch related functions. The nominal number of entries is optional, must be a power of 2, and controls the relative error expected from the sketch. A number of 16384 can be expected to yield errors of roughly +-1.5% in the estimation of uniques. The default number is defined in the sketches-core library, and at the time of this writing was 4096 (about 3% error). The sampling probability is optional and must be from 0 to 1. The default is 1 (no sampling)")
public class DataToArrayOfDoublesSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length < 2) {
            throw new UDFArgumentException("Expected at least 2 arguments");
        }
        ObjectInspectorValidator.validateCategoryPrimitive(inspectors[0], 0);
        int numValues = 0;
        while (numValues + 1 < inspectors.length) {
            ObjectInspectorValidator.validateCategoryPrimitive(inspectors[numValues + 1], numValues + 1);
            PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspectors[numValues + 1];
            if (primitiveInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) break;
            ++numValues;
        }
        if (numValues == 0) {
            throw new UDFArgumentException("Expected at least 1 double value");
        }
        if (inspectors.length > numValues + 1) {
            ObjectInspectorValidator.validateIntegralParameter(inspectors[numValues + 1], numValues + 1);
        }
        if (inspectors.length > numValues + 2) {
            ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[numValues + 2], numValues + 2, PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
        }
        if (inspectors.length > numValues + 3) {
            throw new UDFArgumentException("Unexpected argument " + (numValues + 4));
        }
        return new DataToArrayOfDoublesSketchEvaluator();
    }

    public static class DataToArrayOfDoublesSketchEvaluator
    extends ArrayOfDoublesSketchEvaluator {
        private static final float DEFAULT_SAMPLING_PROBABILITY = 1.0f;
        private PrimitiveObjectInspector keyInspector_;
        private PrimitiveObjectInspector[] valuesInspectors_;
        private PrimitiveObjectInspector samplingProbabilityInspector_;
        private int numValues_;
        private GenericUDAFEvaluator.Mode mode_;

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
            super.init(mode, parameters);
            this.mode_ = mode;
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.keyInspector_ = (PrimitiveObjectInspector)parameters[0];
                this.numValues_ = 0;
                while (this.numValues_ + 1 < parameters.length && ((PrimitiveObjectInspector)parameters[this.numValues_ + 1]).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.DOUBLE) {
                    ++this.numValues_;
                }
                this.valuesInspectors_ = new PrimitiveObjectInspector[this.numValues_];
                for (int i = 0; i < this.numValues_; ++i) {
                    this.valuesInspectors_[i] = (PrimitiveObjectInspector)parameters[i + 1];
                }
                if (parameters.length > this.numValues_ + 1) {
                    this.nominalNumEntriesInspector_ = (PrimitiveObjectInspector)parameters[this.numValues_ + 1];
                }
                if (parameters.length > this.numValues_ + 2) {
                    this.samplingProbabilityInspector_ = (PrimitiveObjectInspector)parameters[this.numValues_ + 2];
                }
            } else {
                this.intermediateInspector_ = (StructObjectInspector)parameters[0];
            }
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.PARTIAL2) {
                return ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("nominalEntries", "numValues", "sketch"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY)));
            }
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            if (data[0] == null) {
                return;
            }
            ArrayOfDoublesSketchState state = (ArrayOfDoublesSketchState)buf;
            if (!state.isInitialized()) {
                this.initializeState(state, data);
            }
            state.update(data, this.keyInspector_, this.valuesInspectors_);
        }

        private void initializeState(ArrayOfDoublesSketchState state, Object[] data) {
            int nominalNumEntries = 4096;
            if (this.nominalNumEntriesInspector_ != null) {
                nominalNumEntries = PrimitiveObjectInspectorUtils.getInt((Object)data[this.numValues_ + 1], (PrimitiveObjectInspector)this.nominalNumEntriesInspector_);
            }
            float samplingProbability = 1.0f;
            if (this.samplingProbabilityInspector_ != null) {
                samplingProbability = PrimitiveObjectInspectorUtils.getFloat((Object)data[this.numValues_ + 2], (PrimitiveObjectInspector)this.samplingProbabilityInspector_);
            }
            state.init(nominalNumEntries, samplingProbability, this.numValues_);
        }

        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            if (this.mode_ == GenericUDAFEvaluator.Mode.PARTIAL1 || this.mode_ == GenericUDAFEvaluator.Mode.COMPLETE) {
                return new ArrayOfDoublesSketchState();
            }
            return new ArrayOfDoublesUnionState();
        }
    }
}

