/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.theta;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;

@Description(name="excludeSketch", value="_FUNC_(firstSketch, secondSketch[, seed]) - Computes the set difference, A-AND-NOT-B,of the given sketches", extended="The return value is a binary blob that contains a compact sketch, which can be operated on by the other sketch-related functions. The seed is optional, and using it is not recommended unless you really know why you need it.")
public class ExcludeSketchUDF
extends UDF {
    public BytesWritable evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes, long hashSeed) {
        Sketch firstSketch = null;
        if (firstSketchBytes != null && firstSketchBytes.getLength() > 0) {
            firstSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(firstSketchBytes), (long)hashSeed);
        }
        Sketch secondSketch = null;
        if (secondSketchBytes != null && secondSketchBytes.getLength() > 0) {
            secondSketch = Sketch.wrap((Memory)BytesWritableHelper.wrapAsMemory(secondSketchBytes), (long)hashSeed);
        }
        AnotB anotb = SetOperation.builder().setSeed(hashSeed).buildANotB();
        byte[] excludeSketchBytes = anotb.aNotB(firstSketch, secondSketch).toByteArray();
        BytesWritable result = new BytesWritable();
        result.set(excludeSketchBytes, 0, excludeSketchBytes.length);
        return result;
    }

    public BytesWritable evaluate(BytesWritable firstSketchBytes, BytesWritable secondSketchBytes) {
        return this.evaluate(firstSketchBytes, secondSketchBytes, 9001L);
    }
}

