/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.quantiles;

import org.apache.datasketches.hive.quantiles.DoublesEvaluator;
import org.apache.datasketches.hive.quantiles.DoublesUnionState;
import org.apache.datasketches.hive.quantiles.ObjectInspectorValidator;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="Union", value="_FUNC_(sketch) - Returns a QuantilesSketch in a serialized form as a binary blob. Input values are also serialized sketches.")
public class UnionDoublesSketchUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] inspectors = info.getParameterObjectInspectors();
        if (inspectors.length != 1 && inspectors.length != 2) {
            throw new UDFArgumentException("One or two arguments expected");
        }
        ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[0], 0, PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        if (inspectors.length == 2) {
            ObjectInspectorValidator.validateGivenPrimitiveCategory(inspectors[1], 1, PrimitiveObjectInspector.PrimitiveCategory.INT);
        }
        return new UnionEvaluator();
    }

    static class UnionEvaluator
    extends DoublesEvaluator {
        UnionEvaluator() {
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer buf, Object[] data) throws HiveException {
            if (data[0] == null) {
                return;
            }
            DoublesUnionState state = (DoublesUnionState)buf;
            if (!state.isInitialized()) {
                int k = 0;
                if (this.kObjectInspector != null) {
                    k = PrimitiveObjectInspectorUtils.getInt((Object)data[1], (PrimitiveObjectInspector)this.kObjectInspector);
                }
                state.init(k);
            }
            this.merge(buf, data[0]);
        }
    }
}

