/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.kll;

import org.apache.datasketches.hive.common.BytesWritableHelper;
import org.apache.datasketches.hive.kll.SketchState;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BytesWritable;

abstract class SketchEvaluator
extends GenericUDAFEvaluator {
    protected PrimitiveObjectInspector inputInspector_;
    protected PrimitiveObjectInspector kInspector_;

    SketchEvaluator() {
    }

    public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] parameters) throws HiveException {
        super.init(mode, parameters);
        this.inputInspector_ = (PrimitiveObjectInspector)parameters[0];
        if ((mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) && parameters.length > 1) {
            this.kInspector_ = (PrimitiveObjectInspector)parameters[1];
        }
        return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.BINARY);
    }

    public void reset(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        SketchState state = (SketchState)buf;
        state.reset();
    }

    public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        return this.terminate(buf);
    }

    public void merge(GenericUDAFEvaluator.AggregationBuffer buf, Object data) throws HiveException {
        if (data == null) {
            return;
        }
        SketchState state = (SketchState)buf;
        Memory serializedSketch = BytesWritableHelper.wrapAsMemory((BytesWritable)this.inputInspector_.getPrimitiveWritableObject(data));
        state.update(KllFloatsSketch.heapify((Memory)serializedSketch));
    }

    public Object terminate(GenericUDAFEvaluator.AggregationBuffer buf) throws HiveException {
        SketchState state = (SketchState)buf;
        KllFloatsSketch resultSketch = state.getResult();
        if (resultSketch == null) {
            return null;
        }
        return new BytesWritable(resultSketch.toByteArray());
    }

    public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new SketchState();
    }
}

