/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.hll;

import org.apache.datasketches.hive.hll.State;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class SketchState
extends State {
    private HllSketch sketch_;

    SketchState() {
    }

    @Override
    boolean isInitialized() {
        return this.sketch_ != null;
    }

    @Override
    void init(int logK, TgtHllType type) {
        super.init(logK, type);
        this.sketch_ = new HllSketch(logK, type);
    }

    @Override
    void update(Object data, PrimitiveObjectInspector objectInspector) {
        switch (objectInspector.getPrimitiveCategory()) {
            case BINARY: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getBinary((Object)data, (PrimitiveObjectInspector)objectInspector).copyBytes());
                return;
            }
            case BYTE: {
                this.sketch_.update((long)PrimitiveObjectInspectorUtils.getByte((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case DOUBLE: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getDouble((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case FLOAT: {
                this.sketch_.update((double)PrimitiveObjectInspectorUtils.getFloat((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case INT: {
                this.sketch_.update((long)PrimitiveObjectInspectorUtils.getInt((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case LONG: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getLong((Object)data, (PrimitiveObjectInspector)objectInspector));
                return;
            }
            case STRING: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getString((Object)data, (PrimitiveObjectInspector)objectInspector).toCharArray());
                return;
            }
            case CHAR: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getHiveChar((Object)data, (PrimitiveObjectInspector)objectInspector).getValue().toCharArray());
                return;
            }
            case VARCHAR: {
                this.sketch_.update(PrimitiveObjectInspectorUtils.getHiveVarchar((Object)data, (PrimitiveObjectInspector)objectInspector).getValue().toCharArray());
                return;
            }
        }
        throw new IllegalArgumentException("Unrecongnized input data type " + data.getClass().getSimpleName() + " category " + objectInspector.getPrimitiveCategory() + ", please use data of the following types: byte, double, float, int, long, char, varchar or string.");
    }

    @Override
    HllSketch getResult() {
        if (this.sketch_ == null) {
            return null;
        }
        return this.sketch_;
    }

    @Override
    void reset() {
        this.sketch_ = null;
    }
}

