/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.TezAppMasterStatus;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.client.TezYarnClient;
import org.apache.tez.common.RPCUtil;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DAGSubmissionTimedOut;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezReflectionException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGClientImpl;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class FrameworkClient {
    protected static final Logger LOG = LoggerFactory.getLogger(FrameworkClient.class);

    public static FrameworkClient createFrameworkClient(TezConfiguration tezConf) {
        boolean isLocal = tezConf.getBoolean("tez.local.mode", false);
        if (isLocal) {
            try {
                return (FrameworkClient)ReflectionUtils.createClazzInstance("org.apache.tez.client.LocalClient");
            }
            catch (TezReflectionException e) {
                throw new TezUncheckedException("Fail to create LocalClient", e);
            }
        }
        return new TezYarnClient(YarnClient.createYarnClient());
    }

    public abstract void init(TezConfiguration var1);

    public abstract void start();

    public abstract void stop();

    public abstract void close() throws IOException;

    public abstract YarnClientApplication createApplication() throws YarnException, IOException;

    public abstract ApplicationId submitApplication(ApplicationSubmissionContext var1) throws YarnException, IOException, TezException;

    public abstract void killApplication(ApplicationId var1) throws YarnException, IOException;

    public abstract ApplicationReport getApplicationReport(ApplicationId var1) throws YarnException, IOException;

    public abstract String getAmHost();

    public abstract int getAmPort();

    public abstract boolean isRunning() throws IOException;

    public TezAppMasterStatus getAMStatus(Configuration conf, ApplicationId appId, UserGroupInformation ugi) throws TezException, ServiceException, IOException {
        DAGClientAMProtocolBlockingPB proxy = this.getProxy(conf, appId, ugi);
        if (proxy == null) {
            return TezAppMasterStatus.INITIALIZING;
        }
        DAGClientAMProtocolRPC.GetAMStatusResponseProto response = proxy.getAMStatus(null, DAGClientAMProtocolRPC.GetAMStatusRequestProto.newBuilder().build());
        return DagTypeConverters.convertTezAppMasterStatusFromProto(response.getStatus());
    }

    public DAGClient submitDag(DAG dag, DAGClientAMProtocolRPC.SubmitDAGRequestProto request, String clientName, ApplicationId sessionAppId, long clientTimeout, UserGroupInformation ugi, TezConfiguration tezConf) throws IOException, TezException, DAGSubmissionTimedOut {
        DAGClientAMProtocolBlockingPB proxy = null;
        try {
            proxy = this.waitForProxy(clientTimeout, tezConf, sessionAppId, ugi);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while trying to create a connection to the AM", e);
        }
        if (proxy == null) {
            try {
                LOG.warn("DAG submission to session timed out, stopping session");
                this.stop();
            }
            catch (Throwable t) {
                LOG.info("Got an exception when trying to stop session", t);
            }
            throw new DAGSubmissionTimedOut("Could not submit DAG to Tez Session, timed out after " + clientTimeout + " seconds");
        }
        String dagId = null;
        try {
            DAGClientAMProtocolRPC.SubmitDAGResponseProto response = proxy.submitDAG(null, request);
            if (response != null) {
                dagId = response.getDagId();
            }
        }
        catch (ServiceException e) {
            RPCUtil.unwrapAndThrowException(e);
        }
        LOG.info("Submitted dag to TezSession, sessionName=" + clientName + ", applicationId=" + sessionAppId + ", dagId=" + dagId + ", dagName=" + dag.getName());
        return this.getDAGClient(sessionAppId, dagId, tezConf, ugi);
    }

    protected DAGClientAMProtocolBlockingPB waitForProxy(long clientTimeout, Configuration conf, ApplicationId sessionAppId, UserGroupInformation ugi) throws IOException, TezException, InterruptedException {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + clientTimeout * 1000L;
        DAGClientAMProtocolBlockingPB proxy = null;
        while ((proxy = TezClientUtils.getAMProxy(this, conf, sessionAppId, ugi)) == null) {
            Thread.sleep(100L);
            if (clientTimeout == -1L || System.currentTimeMillis() <= endTime) continue;
            break;
        }
        return proxy;
    }

    public boolean shutdownSession(Configuration conf, ApplicationId sessionAppId, UserGroupInformation ugi) throws TezException, IOException, ServiceException {
        DAGClientAMProtocolBlockingPB proxy = this.getProxy(conf, sessionAppId, ugi);
        if (proxy != null) {
            DAGClientAMProtocolRPC.ShutdownSessionRequestProto request = DAGClientAMProtocolRPC.ShutdownSessionRequestProto.newBuilder().build();
            proxy.shutdownSession(null, request);
            return true;
        }
        return false;
    }

    protected DAGClientAMProtocolBlockingPB getProxy(Configuration conf, ApplicationId sessionAppId, UserGroupInformation ugi) throws TezException, IOException {
        return TezClientUtils.getAMProxy(this, conf, sessionAppId, ugi);
    }

    public DAGClient getDAGClient(ApplicationId appId, String dagId, TezConfiguration tezConf, UserGroupInformation ugi) {
        return new DAGClientImpl(appId, dagId, tezConf, this, ugi);
    }
}

