/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.OpenTxn;
import org.apache.hadoop.hive.metastore.txn.entities.OpenTxnList;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetOpenTxnsListHandler
implements QueryHandler<OpenTxnList> {
    private static final Logger LOG = LoggerFactory.getLogger(GetOpenTxnsListHandler.class);
    private static final String OPEN_TXNS_QUERY = "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\", (%s - \"TXN_STARTED\") FROM \"TXNS\" ORDER BY \"TXN_ID\"";
    private static final String OPEN_TXNS_INFO_QUERY = "SELECT \"TXN_ID\", \"TXN_STATE\", \"TXN_TYPE\", (%s - \"TXN_STARTED\"), \"TXN_USER\", \"TXN_HOST\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\" FROM \"TXNS\" ORDER BY \"TXN_ID\"";
    private final boolean infoFields;
    private final long openTxnTimeOutMillis;

    public GetOpenTxnsListHandler(boolean infoFields, long openTxnTimeOutMillis) {
        this.infoFields = infoFields;
        this.openTxnTimeOutMillis = openTxnTimeOutMillis;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return String.format(this.infoFields ? OPEN_TXNS_INFO_QUERY : OPEN_TXNS_QUERY, TxnUtils.getEpochFn(databaseProduct));
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return null;
    }

    public OpenTxnList extractData(ResultSet rs) throws SQLException, DataAccessException {
        long hwm = 0L;
        long openTxnLowBoundary = 0L;
        ArrayList<OpenTxn> txnInfos = new ArrayList<OpenTxn>();
        while (rs.next()) {
            TxnStatus state;
            long txnId = rs.getLong(1);
            long age = rs.getLong(4);
            hwm = txnId;
            if (age < this.openTxnTimeOutMillis) {
                ++openTxnLowBoundary;
                while (txnId > openTxnLowBoundary) {
                    txnInfos.add(new OpenTxn(openTxnLowBoundary, TxnStatus.OPEN, TxnType.DEFAULT));
                    LOG.debug("Open transaction added for missing value in TXNS {}", (Object)JavaUtils.txnIdToString((long)openTxnLowBoundary));
                    ++openTxnLowBoundary;
                }
            } else {
                openTxnLowBoundary = txnId;
            }
            if ((state = TxnStatus.fromString(rs.getString(2))) == TxnStatus.COMMITTED) continue;
            OpenTxn txnInfo = new OpenTxn(txnId, state, TxnType.findByValue((int)rs.getInt(3)));
            if (this.infoFields) {
                txnInfo.setUser(rs.getString(5));
                txnInfo.setHost(rs.getString(6));
                txnInfo.setStartedTime(rs.getLong(7));
                txnInfo.setLastHeartBeatTime(rs.getLong(8));
            }
            txnInfos.add(txnInfo);
        }
        LOG.debug("Got OpenTxnList with hwm: {} and openTxnList size {}.", (Object)hwm, (Object)txnInfos.size());
        return new OpenTxnList(hwm, txnInfos);
    }
}

