/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionMetricsData;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveCompactionMetricsDataCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.CompactionMetricsDataHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class UpdateCompactionMetricsDataFunction
implements TransactionalFunction<Boolean> {
    private final CompactionMetricsData data;

    public UpdateCompactionMetricsDataFunction(CompactionMetricsData data) {
        this.data = data;
    }

    @Override
    public Boolean execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        boolean updateRes;
        CompactionMetricsData prevMetricsData = jdbcResource.execute(new CompactionMetricsDataHandler(this.data.getDbName(), this.data.getTblName(), this.data.getPartitionName(), this.data.getMetricType()));
        if (this.data.getMetricValue() >= this.data.getThreshold()) {
            updateRes = prevMetricsData != null ? this.updateCompactionMetricsData(this.data, prevMetricsData, jdbcResource.getJdbcTemplate()) : this.createCompactionMetricsData(this.data, jdbcResource.getJdbcTemplate());
        } else if (prevMetricsData != null) {
            int result = jdbcResource.execute(new RemoveCompactionMetricsDataCommand(this.data.getDbName(), this.data.getTblName(), this.data.getPartitionName(), this.data.getMetricType()));
            updateRes = result > 0;
        } else {
            return true;
        }
        return updateRes;
    }

    private boolean updateCompactionMetricsData(CompactionMetricsData data, CompactionMetricsData prevData, NamedParameterJdbcTemplate jdbcTemplate) {
        return jdbcTemplate.update("UPDATE \"COMPACTION_METRICS_CACHE\" SET \"CMC_METRIC_VALUE\" = :value, \"CMC_VERSION\" = :newVersion WHERE \"CMC_DATABASE\" = :db AND \"CMC_TABLE\" = :table AND \"CMC_METRIC_TYPE\" = :type AND \"CMC_VERSION\" = :oldVersion AND (:partition IS NULL OR \"CMC_PARTITION\" = :partition)", (SqlParameterSource)new MapSqlParameterSource().addValue("value", (Object)data.getMetricValue()).addValue("oldVersion", (Object)prevData.getVersion()).addValue("newVersion", (Object)(prevData.getVersion() + 1)).addValue("db", (Object)data.getDbName()).addValue("table", (Object)data.getTblName()).addValue("type", (Object)data.getMetricType().toString()).addValue("partition", (Object)data.getPartitionName(), 12)) > 0;
    }

    private boolean createCompactionMetricsData(CompactionMetricsData data, NamedParameterJdbcTemplate jdbcTemplate) {
        return jdbcTemplate.update("INSERT INTO \"COMPACTION_METRICS_CACHE\" ( \"CMC_DATABASE\", \"CMC_TABLE\", \"CMC_PARTITION\", \"CMC_METRIC_TYPE\", \"CMC_METRIC_VALUE\", \"CMC_VERSION\" ) VALUES (:db, :table, :partition, :type, :value, 1)", (SqlParameterSource)new MapSqlParameterSource().addValue("db", (Object)data.getDbName()).addValue("table", (Object)data.getTblName()).addValue("partition", (Object)data.getPartitionName(), 12).addValue("type", (Object)data.getMetricType().toString()).addValue("value", (Object)data.getMetricValue())) > 0;
    }
}

