/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.MetaStoreListenerNotifier;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.OpenTxnEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.MinOpenTxnIdWaterMarkFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TargetTxnIdListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class OpenTxnsFunction
implements TransactionalFunction<List<Long>> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTxnsFunction.class);
    private static final String TXN_TMP_STATE = "_";
    private static final String TXNS_INSERT_QRY = "INSERT INTO \"TXNS\" (\"TXN_STATE\", \"TXN_STARTED\", \"TXN_LAST_HEARTBEAT\", \"TXN_USER\", \"TXN_HOST\", \"TXN_TYPE\") VALUES(?,%s,%s,?,?,?)";
    private final OpenTxnRequest rqst;
    private final long openTxnTimeOutMillis;
    private final List<TransactionalMetaStoreEventListener> transactionalListeners;

    public OpenTxnsFunction(OpenTxnRequest rqst, long openTxnTimeOutMillis, List<TransactionalMetaStoreEventListener> transactionalListeners) {
        this.rqst = rqst;
        this.openTxnTimeOutMillis = openTxnTimeOutMillis;
        this.transactionalListeners = transactionalListeners;
    }

    @Override
    public List<Long> execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        boolean isHiveReplTxn;
        int maxTxns;
        DatabaseProduct dbProduct = jdbcResource.getDatabaseProduct();
        int numTxns = this.rqst.getNum_txns();
        if (numTxns > (maxTxns = MetastoreConf.getIntVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_MAX_OPEN_BATCH))) {
            numTxns = maxTxns;
        }
        List<PreparedStatement> insertPreparedStmts = null;
        TxnType txnType = this.rqst.isSetTxn_type() ? this.rqst.getTxn_type() : TxnType.DEFAULT;
        boolean isReplayedReplTxn = txnType == TxnType.REPL_CREATED;
        boolean bl = isHiveReplTxn = this.rqst.isSetReplPolicy() && txnType == TxnType.DEFAULT;
        if (isReplayedReplTxn) {
            assert (this.rqst.isSetReplPolicy());
            List<Long> targetTxnIdList = jdbcResource.execute(new TargetTxnIdListHandler(this.rqst.getReplPolicy(), this.rqst.getReplSrcTxnIds()));
            if (!targetTxnIdList.isEmpty()) {
                if (targetTxnIdList.size() != this.rqst.getReplSrcTxnIds().size()) {
                    LOG.warn("target txn id number {} is not matching with source txn id number {}", targetTxnIdList, (Object)this.rqst.getReplSrcTxnIds());
                }
                LOG.info("Target transactions {} are present for repl policy : {} and Source transaction id : {}", new Object[]{targetTxnIdList, this.rqst.getReplPolicy(), this.rqst.getReplSrcTxnIds().toString()});
                return targetTxnIdList;
            }
        }
        long minOpenTxnId = 0L;
        if (TxnHandler.ConfVars.useMinHistoryLevel()) {
            minOpenTxnId = new MinOpenTxnIdWaterMarkFunction(this.openTxnTimeOutMillis).execute(jdbcResource);
        }
        ArrayList<Long> txnIds = new ArrayList<Long>(numTxns);
        boolean genKeySupport = dbProduct.supportsGetGeneratedKeys();
        genKeySupport = genKeySupport || numTxns == 1;
        String insertQuery = String.format(TXNS_INSERT_QRY, TxnUtils.getEpochFn(dbProduct), TxnUtils.getEpochFn(dbProduct));
        LOG.debug("Going to execute insert <{}>", (Object)insertQuery);
        Connection dbConn = jdbcResource.getConnection();
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = jdbcResource.getJdbcTemplate();
        int maxBatchSize = MetastoreConf.getIntVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
        try (PreparedStatement ps = dbConn.prepareStatement(insertQuery, new String[]{"TXN_ID"});){
            String state;
            String string = state = genKeySupport ? TxnStatus.OPEN.getSqlConst() : TXN_TMP_STATE;
            if (numTxns == 1) {
                ps.setString(1, state);
                ps.setString(2, this.rqst.getUser());
                ps.setString(3, this.rqst.getHostname());
                ps.setInt(4, txnType.getValue());
                txnIds.addAll(this.executeTxnInsertBatchAndExtractGeneratedKeys(namedParameterJdbcTemplate, true, ps, false));
            } else {
                for (int i = 0; i < numTxns; ++i) {
                    ps.setString(1, state);
                    ps.setString(2, this.rqst.getUser());
                    ps.setString(3, this.rqst.getHostname());
                    ps.setInt(4, txnType.getValue());
                    ps.addBatch();
                    if ((i + 1) % maxBatchSize != 0) continue;
                    txnIds.addAll(this.executeTxnInsertBatchAndExtractGeneratedKeys(namedParameterJdbcTemplate, genKeySupport, ps, true));
                }
                if (numTxns % maxBatchSize != 0) {
                    txnIds.addAll(this.executeTxnInsertBatchAndExtractGeneratedKeys(namedParameterJdbcTemplate, genKeySupport, ps, true));
                }
            }
        }
        catch (SQLException e) {
            throw new UncategorizedSQLException(null, null, e);
        }
        assert (txnIds.size() == numTxns);
        this.addTxnToMinHistoryLevel(jdbcResource.getJdbcTemplate().getJdbcTemplate(), maxBatchSize, txnIds, minOpenTxnId);
        if (isReplayedReplTxn) {
            ArrayList<String> rowsRepl = new ArrayList<String>(numTxns);
            List<String> params = Collections.singletonList(this.rqst.getReplPolicy());
            ArrayList<List<String>> paramsList = new ArrayList<List<String>>(numTxns);
            for (int i = 0; i < numTxns; ++i) {
                rowsRepl.add("?," + String.valueOf(this.rqst.getReplSrcTxnIds().get(i)) + "," + String.valueOf(txnIds.get(i)));
                paramsList.add(params);
            }
            try {
                insertPreparedStmts = jdbcResource.getSqlGenerator().createInsertValuesPreparedStmt(dbConn, "\"REPL_TXN_MAP\" (\"RTM_REPL_POLICY\", \"RTM_SRC_TXN_ID\", \"RTM_TARGET_TXN_ID\")", rowsRepl, paramsList);
                Iterator<PreparedStatement> i = insertPreparedStmts.iterator();
                while (i.hasNext()) {
                    PreparedStatement pst;
                    PreparedStatement ppst = pst = i.next();
                    try {
                        ppst.execute();
                    }
                    finally {
                        if (ppst == null) continue;
                        ppst.close();
                    }
                }
            }
            catch (SQLException e) {
                throw new UncategorizedSQLException(null, null, e);
            }
        }
        if (this.transactionalListeners != null && !isHiveReplTxn) {
            MetaStoreListenerNotifier.notifyEventWithDirectSql(this.transactionalListeners, EventMessage.EventType.OPEN_TXN, new OpenTxnEvent(txnIds, txnType), dbConn, jdbcResource.getSqlGenerator());
        }
        return txnIds;
    }

    @Deprecated
    private void addTxnToMinHistoryLevel(JdbcTemplate jdbcTemplate, int batchSize, List<Long> txnIds, long minOpenTxnId) {
        if (!TxnHandler.ConfVars.useMinHistoryLevel()) {
            return;
        }
        String sql = "INSERT INTO \"MIN_HISTORY_LEVEL\" (\"MHL_TXNID\", \"MHL_MIN_OPEN_TXNID\") VALUES(?, ?)";
        LOG.debug("Going to execute insert batch: <{}>", (Object)sql);
        jdbcTemplate.batchUpdate(sql, txnIds, batchSize, (ps, argument) -> {
            ps.setLong(1, (long)argument);
            ps.setLong(2, minOpenTxnId);
        });
        LOG.info("Added entries to MIN_HISTORY_LEVEL for current txns: ({}) with min_open_txn: {}", txnIds, (Object)minOpenTxnId);
    }

    private List<Long> executeTxnInsertBatchAndExtractGeneratedKeys(NamedParameterJdbcTemplate jdbcTemplate, boolean genKeySupport, PreparedStatement ps, boolean batch) throws SQLException {
        List<Long> txnIds = new ArrayList<Long>();
        if (batch) {
            ps.executeBatch();
        } else {
            ps.execute();
        }
        if (genKeySupport) {
            try (ResultSet generatedKeys = ps.getGeneratedKeys();){
                while (generatedKeys.next()) {
                    txnIds.add(generatedKeys.getLong(1));
                }
            }
        } else {
            txnIds = jdbcTemplate.query("SELECT \"TXN_ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = :tmpState", (SqlParameterSource)new MapSqlParameterSource().addValue("tmpState", (Object)TXN_TMP_STATE), (rs, rowNum) -> rs.getLong(1));
            jdbcTemplate.update("UPDATE \"TXNS\" SET \"TXN_STATE\" = :newState WHERE \"TXN_STATE\" = :tmpState", (SqlParameterSource)new MapSqlParameterSource().addValue("newState", (Object)TxnStatus.OPEN.getSqlConst()).addValue("tmpState", (Object)TXN_TMP_STATE));
        }
        return txnIds;
    }
}

