/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.DeleteReplTxnMapEntryCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.FindTxnStateHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetOpenTxnTypeAndLockHandler;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.TargetTxnIdListHandler;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortTxnFunction
implements TransactionalFunction<TxnType> {
    private static final Logger LOG = LoggerFactory.getLogger(AbortTxnFunction.class);
    private final AbortTxnRequest rqst;

    public AbortTxnFunction(AbortTxnRequest rqst) {
        this.rqst = rqst;
    }

    @Override
    public TxnType execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException, NoSuchTxnException, TxnAbortedException {
        TxnType txnType;
        boolean isHiveReplTxn;
        long txnid = this.rqst.getTxnid();
        TxnErrorMsg txnErrorMsg = TxnErrorMsg.NONE;
        long sourceTxnId = -1L;
        boolean isReplayedReplTxn = TxnType.REPL_CREATED.equals((Object)this.rqst.getTxn_type());
        boolean bl = isHiveReplTxn = this.rqst.isSetReplPolicy() && TxnType.DEFAULT.equals((Object)this.rqst.getTxn_type());
        if (isReplayedReplTxn) {
            assert (this.rqst.isSetReplPolicy());
            sourceTxnId = this.rqst.getTxnid();
            List<Long> targetTxnIds = jdbcResource.execute(new TargetTxnIdListHandler(this.rqst.getReplPolicy(), Collections.singletonList(sourceTxnId)));
            if (targetTxnIds.isEmpty()) {
                LOG.info("Target txn id is missing for source txn id : {} and repl policy {}", (Object)sourceTxnId, (Object)this.rqst.getReplPolicy());
                return null;
            }
            assert (targetTxnIds.size() == 1);
            txnid = targetTxnIds.get(0);
        }
        if ((txnType = jdbcResource.execute(new GetOpenTxnTypeAndLockHandler(jdbcResource.getSqlGenerator(), txnid))) == null) {
            TxnStatus status = jdbcResource.execute(new FindTxnStateHandler(txnid));
            if (status == TxnStatus.ABORTED) {
                if (isReplayedReplTxn) {
                    LOG.warn("Invalid state ABORTED for transactions started using replication replay task");
                    jdbcResource.execute(new DeleteReplTxnMapEntryCommand(sourceTxnId, this.rqst.getReplPolicy()));
                }
                LOG.info("abortTxn({}) requested by it is already {}", (Object)JavaUtils.txnIdToString((long)txnid), (Object)TxnStatus.ABORTED);
                return null;
            }
            TxnUtils.raiseTxnUnexpectedState(status, txnid);
        }
        if (isReplayedReplTxn) {
            txnErrorMsg = TxnErrorMsg.ABORT_REPLAYED_REPL_TXN;
        } else if (isHiveReplTxn) {
            txnErrorMsg = TxnErrorMsg.ABORT_DEFAULT_REPL_TXN;
        } else if (this.rqst.isSetErrorCode()) {
            txnErrorMsg = TxnErrorMsg.getTxnErrorMsg(this.rqst.getErrorCode());
        }
        new AbortTxnsFunction(Collections.singletonList(txnid), false, true, isReplayedReplTxn, txnErrorMsg).execute(jdbcResource);
        if (isReplayedReplTxn) {
            jdbcResource.execute(new DeleteReplTxnMapEntryCommand(sourceTxnId, this.rqst.getReplPolicy()));
        }
        return txnType;
    }
}

