/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

public enum TxnErrorMsg {
    NONE(50000, "none"),
    ABORT_QUERY(50001, "abort by query command"),
    ABORT_CONCURRENT(50002, "concurrent committed transaction"),
    ABORT_WRITE_CONFLICT(50003, "write conflicts"),
    ABORT_TIMEOUT(50004, "heartbeat time-out"),
    ABORT_ROLLBACK(50005, "rollback"),
    ABORT_COMPACTION_TXN(50006, "compaction transaction abort"),
    ABORT_MSCK_TXN(50007, "msck transaction abort"),
    ABORT_MIGRATION_TXN(50008, "managed migration transaction abort"),
    ABORT_DEFAULT_REPL_TXN(51000, "Replication:default replication transaction abort"),
    ABORT_REPLAYED_REPL_TXN(51001, "Replication:replayed replication transaction abort"),
    ABORT_REPL_WRITEID_TXN(51002, "Replication:abort of allocated txns for referring mapped write ids as aborted ones"),
    ABORT_FETCH_FAILOVER_METADATA(51003, "Replication:abort of txns while trying to fetch failover metadata"),
    ABORT_WRITE_TXN_AFTER_TIMEOUT(51004, "Replication:abort of write txns for the db under replication"),
    ABORT_ONGOING_TXN_FOR_TARGET_DB(51005, "Replication:abort of ongoing txns(opened prior to failover) for the target database");

    private final long errorCode;
    private final String errorMsg;

    private TxnErrorMsg(int errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        return this.errorMsg;
    }

    public static TxnErrorMsg getTxnErrorMsg(long errorCode) {
        for (TxnErrorMsg txnErrorMsg : TxnErrorMsg.values()) {
            if (txnErrorMsg.getErrorCode() != errorCode) continue;
            return txnErrorMsg;
        }
        return NONE;
    }

    public String toSqlString() {
        return "'" + this.toString() + "'";
    }
}

