/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaToolTaskCreateCatalog
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaToolTaskCreateCatalog.class.getName());
    private String catName;
    private String location;
    private String description;
    private boolean ifNotExists;
    private static final String CATALOG_EXISTS_QUERY = "select <q>NAME<q>   from <q>CTLGS<q>  where <q>NAME<q> = '%s'";
    private static final String NEXT_CATALOG_ID_QUERY = "select max(<q>CTLG_ID<q>)   from <q>CTLGS<q>";
    private static final String ADD_CATALOG_STMT = "insert into <q>CTLGS<q> (<q>CTLG_ID<q>, <q>NAME<q>, <qa>DESC<qa>, <q>LOCATION_URI<q>)      values (%d, '%s', '%s', '%s')";

    SchemaToolTaskCreateCatalog() {
    }

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.catName = StringUtils.normalizeIdentifier((String)cl.getOptionValue("createCatalog"));
        this.location = cl.getOptionValue("catalogLocation");
        this.description = cl.getOptionValue("catalogDescription");
        this.ifNotExists = cl.hasOption("ifNotExists");
    }

    @Override
    void execute() throws HiveMetaException {
        System.out.println("Create catalog " + this.catName + " at location " + this.location);
        Connection conn = this.schemaTool.getConnectionToMetastore(true);
        boolean success = false;
        try {
            conn.setAutoCommit(false);
            try (Statement stmt = conn.createStatement();){
                if (this.ifNotExists && this.catalogExists(stmt)) {
                    return;
                }
                int catNum = this.getNextCatalogId(stmt);
                this.addCatalog(conn, stmt, catNum);
                success = true;
            }
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to add catalog", (Throwable)e);
        }
        finally {
            try {
                if (!success) {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                LOG.error("Failed to rollback, everything will probably go bad from here.", (Throwable)e);
            }
        }
    }

    private boolean catalogExists(Statement stmt) throws SQLException {
        String query = String.format(this.schemaTool.quote(CATALOG_EXISTS_QUERY), this.catName);
        LOG.debug("Going to run " + query);
        try (ResultSet rs = stmt.executeQuery(query);){
            if (rs.next()) {
                System.out.println("Catalog " + this.catName + " already exists");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private int getNextCatalogId(Statement stmt) throws SQLException, HiveMetaException {
        String query = this.schemaTool.quote(NEXT_CATALOG_ID_QUERY);
        LOG.debug("Going to run " + query);
        try (ResultSet rs = stmt.executeQuery(query);){
            if (!rs.next()) {
                throw new HiveMetaException("No catalogs found, have you upgraded the database?");
            }
            int nextId = rs.getInt(1) + 1;
            int floor = 0x40000000;
            int n = Math.max(nextId, floor);
            return n;
        }
    }

    private void addCatalog(Connection conn, Statement stmt, int catNum) throws SQLException {
        String update = String.format(this.schemaTool.quote(ADD_CATALOG_STMT), catNum, this.catName, this.description, this.location);
        LOG.debug("Going to run " + update);
        stmt.execute(update);
        conn.commit();
    }
}

