/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class TypeInfoToSchema {
    private long recordCounter = 0L;

    public Schema convert(List<String> columnNames, List<TypeInfo> columnTypes, List<String> columnComments, String namespace, String name, String doc) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (int i = 0; i < columnNames.size(); ++i) {
            String comment = columnComments.size() > i ? columnComments.get(i) : null;
            Schema.Field avroField = this.createAvroField(columnNames.get(i), columnTypes.get(i), comment);
            fields.addAll(this.getFields(avroField));
        }
        if (name == null || name.isEmpty()) {
            name = "baseRecord";
        }
        Schema avroSchema = Schema.createRecord((String)name, (String)doc, (String)namespace, (boolean)false);
        avroSchema.setFields(fields);
        return avroSchema;
    }

    private Schema.Field createAvroField(String name, TypeInfo typeInfo, String comment) {
        return new Schema.Field(name, this.createAvroSchema(typeInfo), comment, (Object)JsonProperties.NULL_VALUE);
    }

    private Schema createAvroSchema(TypeInfo typeInfo) {
        Schema schema = null;
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                schema = this.createAvroPrimitive(typeInfo);
                break;
            }
            case LIST: {
                schema = this.createAvroArray(typeInfo);
                break;
            }
            case MAP: {
                schema = this.createAvroMap(typeInfo);
                break;
            }
            case STRUCT: {
                schema = this.createAvroRecord(typeInfo);
                break;
            }
            case UNION: {
                schema = this.createAvroUnion(typeInfo);
            }
        }
        return this.wrapInUnionWithNull(schema);
    }

    private Schema createAvroPrimitive(TypeInfo typeInfo) {
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        return switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case PrimitiveObjectInspector.PrimitiveCategory.STRING -> Schema.create((Schema.Type)Schema.Type.STRING);
            case PrimitiveObjectInspector.PrimitiveCategory.CHAR -> AvroSerdeUtils.getSchemaFor("{\"type\":\"string\",\"logicalType\":\"char\",\"maxLength\":" + ((CharTypeInfo)typeInfo).getLength() + "}");
            case PrimitiveObjectInspector.PrimitiveCategory.VARCHAR -> AvroSerdeUtils.getSchemaFor("{\"type\":\"string\",\"logicalType\":\"varchar\",\"maxLength\":" + ((VarcharTypeInfo)typeInfo).getLength() + "}");
            case PrimitiveObjectInspector.PrimitiveCategory.BINARY -> Schema.create((Schema.Type)Schema.Type.BYTES);
            case PrimitiveObjectInspector.PrimitiveCategory.BYTE -> Schema.create((Schema.Type)Schema.Type.INT);
            case PrimitiveObjectInspector.PrimitiveCategory.SHORT -> Schema.create((Schema.Type)Schema.Type.INT);
            case PrimitiveObjectInspector.PrimitiveCategory.INT -> Schema.create((Schema.Type)Schema.Type.INT);
            case PrimitiveObjectInspector.PrimitiveCategory.LONG -> Schema.create((Schema.Type)Schema.Type.LONG);
            case PrimitiveObjectInspector.PrimitiveCategory.FLOAT -> Schema.create((Schema.Type)Schema.Type.FLOAT);
            case PrimitiveObjectInspector.PrimitiveCategory.DOUBLE -> Schema.create((Schema.Type)Schema.Type.DOUBLE);
            case PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN -> Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            case PrimitiveObjectInspector.PrimitiveCategory.DECIMAL -> {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                String precision = String.valueOf(decimalTypeInfo.precision());
                String scale = String.valueOf(decimalTypeInfo.scale());
                yield AvroSerdeUtils.getSchemaFor("{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":" + precision + ",\"scale\":" + scale + "}");
            }
            case PrimitiveObjectInspector.PrimitiveCategory.DATE -> AvroSerdeUtils.getSchemaFor("{\"type\":\"int\",\"logicalType\":\"date\"}");
            case PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP -> AvroSerdeUtils.getSchemaFor("{\"type\":\"long\",\"logicalType\":\"timestamp-millis\"}");
            case PrimitiveObjectInspector.PrimitiveCategory.VOID -> Schema.create((Schema.Type)Schema.Type.NULL);
            default -> throw new UnsupportedOperationException(String.valueOf(typeInfo) + " is not supported.");
        };
    }

    private Schema createAvroUnion(TypeInfo typeInfo) {
        ArrayList<Schema> childSchemas = new ArrayList<Schema>();
        for (TypeInfo childTypeInfo : ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos()) {
            Schema childSchema = this.createAvroSchema(childTypeInfo);
            if (childSchema.getType() == Schema.Type.UNION) {
                childSchemas.addAll(childSchema.getTypes());
                continue;
            }
            childSchemas.add(childSchema);
        }
        return Schema.createUnion(this.removeDuplicateNullSchemas(childSchemas));
    }

    private Schema createAvroRecord(TypeInfo typeInfo) {
        ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
        List<String> allStructFieldNames = ((StructTypeInfo)typeInfo).getAllStructFieldNames();
        List<TypeInfo> allStructFieldTypeInfos = ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos();
        if (allStructFieldNames.size() != allStructFieldTypeInfos.size()) {
            throw new IllegalArgumentException("Failed to generate avro schema from hive schema. name and column type differs. names = " + String.valueOf(allStructFieldNames) + ", types = " + String.valueOf(allStructFieldTypeInfos));
        }
        for (int i = 0; i < allStructFieldNames.size(); ++i) {
            TypeInfo childTypeInfo = allStructFieldTypeInfos.get(i);
            Schema.Field grandChildSchemaField = this.createAvroField(allStructFieldNames.get(i), childTypeInfo, childTypeInfo.toString());
            List<Schema.Field> grandChildFields = this.getFields(grandChildSchemaField);
            childFields.addAll(grandChildFields);
        }
        Schema recordSchema = Schema.createRecord((String)("record_" + this.recordCounter), (String)typeInfo.toString(), null, (boolean)false);
        ++this.recordCounter;
        recordSchema.setFields(childFields);
        return recordSchema;
    }

    private Schema createAvroMap(TypeInfo typeInfo) {
        TypeInfo keyTypeInfo = ((MapTypeInfo)typeInfo).getMapKeyTypeInfo();
        if (((PrimitiveTypeInfo)keyTypeInfo).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UnsupportedOperationException("Key of Map can only be a String");
        }
        TypeInfo valueTypeInfo = ((MapTypeInfo)typeInfo).getMapValueTypeInfo();
        Schema valueSchema = this.createAvroSchema(valueTypeInfo);
        return Schema.createMap((Schema)valueSchema);
    }

    private Schema createAvroArray(TypeInfo typeInfo) {
        ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
        Schema listSchema = this.createAvroSchema(listTypeInfo.getListElementTypeInfo());
        return Schema.createArray((Schema)listSchema);
    }

    private List<Schema.Field> getFields(Schema.Field schemaField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        JsonProperties.Null nullDefault = JsonProperties.NULL_VALUE;
        if (schemaField.schema().getType() == Schema.Type.RECORD) {
            for (Schema.Field field : schemaField.schema().getFields()) {
                fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), (Object)nullDefault));
            }
        } else {
            fields.add(new Schema.Field(schemaField.name(), schemaField.schema(), schemaField.doc(), (Object)nullDefault));
        }
        return fields;
    }

    private Schema wrapInUnionWithNull(Schema schema) {
        Schema wrappedSchema = schema;
        switch (schema.getType()) {
            case NULL: {
                break;
            }
            case UNION: {
                List<Schema> existingSchemas = this.removeDuplicateNullSchemas(schema.getTypes());
                wrappedSchema = Schema.createUnion(existingSchemas);
                break;
            }
            default: {
                wrappedSchema = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
            }
        }
        return wrappedSchema;
    }

    private List<Schema> removeDuplicateNullSchemas(List<Schema> childSchemas) {
        ArrayList<Schema> prunedSchemas = new ArrayList<Schema>();
        boolean isNullPresent = false;
        for (Schema schema : childSchemas) {
            if (schema.getType() == Schema.Type.NULL) {
                isNullPresent = true;
                continue;
            }
            prunedSchemas.add(schema);
        }
        if (isNullPresent) {
            prunedSchemas.add(0, Schema.create((Schema.Type)Schema.Type.NULL));
        }
        return prunedSchemas;
    }
}

