/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.Credentials;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.input.MRInputLegacy;
import org.apache.tez.mapreduce.input.MultiMRInput;

@InterfaceAudience.Private
public class LlapTezUtils {
    public static boolean isSourceOfInterest(String inputClassName) {
        return !inputClassName.equals(MRInputLegacy.class.getName()) && !inputClassName.equals(MultiMRInput.class.getName()) && !inputClassName.equals(MRInput.class.getName());
    }

    public static String getDagId(JobConf job) {
        return job.get("tez.mapreduce.dag.id");
    }

    public static String getFragmentId(JobConf job) {
        String taskAttemptId = job.get("tez.mapreduce.task.attempt.id");
        if (taskAttemptId != null) {
            return LlapTezUtils.stripAttemptPrefix(taskAttemptId);
        }
        return null;
    }

    public static String stripAttemptPrefix(String s) {
        if (s.startsWith("attempt")) {
            return s.substring("attempt".length() + 1);
        }
        return s;
    }

    public static ByteBuffer serializeCredentials(Credentials credentials) throws IOException {
        Credentials containerCredentials = new Credentials();
        containerCredentials.addAll(credentials);
        DataOutputBuffer containerTokensDob = new DataOutputBuffer();
        containerCredentials.writeTokenStorageToStream((DataOutputStream)containerTokensDob);
        return ByteBuffer.wrap(containerTokensDob.getData(), 0, containerTokensDob.getLength());
    }
}

