/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;

public class EncryptionZoneUtils {
    private EncryptionZoneUtils() {
    }

    public static boolean isPathEncrypted(Path path, Configuration conf) throws IOException {
        Path fullPath = path.isAbsolute() ? path : path.getFileSystem(conf).makeQualified(path);
        return EncryptionZoneUtils.getEncryptionZoneForPath(fullPath, conf) != null;
    }

    public static EncryptionZone getEncryptionZoneForPath(Path path, Configuration conf) throws IOException {
        URI uri = path.getFileSystem(conf).getUri();
        if ("hdfs".equals(uri.getScheme())) {
            HdfsAdmin hdfsAdmin = new HdfsAdmin(uri, conf);
            if (path.getFileSystem(conf).exists(path)) {
                return hdfsAdmin.getEncryptionZoneForPath(path);
            }
            if (!path.getParent().equals((Object)path)) {
                return EncryptionZoneUtils.getEncryptionZoneForPath(path.getParent(), conf);
            }
            return null;
        }
        return null;
    }

    public static void createEncryptionZone(Path path, String keyName, Configuration conf) throws IOException {
        URI uri = path.getFileSystem(conf).getUri();
        if (!"hdfs".equals(uri.getScheme())) {
            throw new UnsupportedOperationException("Cannot create encryption zone for scheme {}" + uri.getScheme());
        }
        HdfsAdmin hdfsAdmin = new HdfsAdmin(uri, conf);
        hdfsAdmin.createEncryptionZone(path, keyName);
    }
}

