/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertySchema;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.apache.hadoop.hive.metastore.properties.PropertyType;

public class HMSPropertyManager
extends PropertyManager {
    private static final String CLUSTER_PREFIX = "cluster";
    private static final String DATABASE_PREFIX = "database";
    private static final String TABLE_PREFIX = "table";
    private static final Map<Integer, MaintenanceOpType> MOP;
    private static final Map<Integer, MaintenanceOpStatus> MOS;
    public static final PropertyType<MaintenanceOpType> MAINTENANCE_OPERATION;
    public static final PropertyType<MaintenanceOpStatus> MAINTENANCE_STATUS;
    public static final PropertySchema CLUSTER_SCHEMA;
    public static final PropertySchema DATABASE_SCHEMA;
    public static final PropertySchema TABLE_SCHEMA;
    private static final PropertySchema[] SCHEMAS;

    public static MaintenanceOpType findOpType(int ordinal) {
        return MOP.get(ordinal);
    }

    public static MaintenanceOpStatus findOpStatus(int ordinal) {
        return MOS.get(ordinal);
    }

    public HMSPropertyManager(String ns, PropertyStore store) {
        super(ns, Objects.requireNonNull(store));
    }

    public HMSPropertyManager(PropertyStore store) {
        this("hms", store);
    }

    public static void declareClusterProperty(String name, PropertyType<?> type, Object defaultValue) {
        CLUSTER_SCHEMA.declareProperty(name, type, defaultValue);
    }

    public static void declareDatabaseProperty(String name, PropertyType<?> type, Object defaultValue) {
        DATABASE_SCHEMA.declareProperty(name, type, defaultValue);
    }

    public static void declareTableProperty(String name, PropertyType<?> type, Object defaultValue) {
        TABLE_SCHEMA.declareProperty(name, type, defaultValue);
    }

    @Override
    public PropertySchema getSchema(String schemaName) {
        switch (schemaName) {
            case "cluster": {
                return CLUSTER_SCHEMA;
            }
            case "database": {
                return DATABASE_SCHEMA;
            }
            case "table": {
                return TABLE_SCHEMA;
            }
        }
        return null;
    }

    @Override
    protected PropertySchema schemaOf(String[] keys) {
        return keys.length > 0 && keys.length < SCHEMAS.length ? SCHEMAS[keys.length - 1] : TABLE_SCHEMA;
    }

    @Override
    protected int getMapNameLength(String[] keys) {
        return SCHEMAS.length;
    }

    static {
        PropertyManager.declare("hms", HMSPropertyManager.class);
        MOP = new HashMap<Integer, MaintenanceOpType>(MaintenanceOpType.values().length);
        Arrays.stream(MaintenanceOpType.values()).forEach(e -> MOP.put(e.ordinal(), (MaintenanceOpType)((Object)e)));
        MOS = new HashMap<Integer, MaintenanceOpStatus>(MaintenanceOpStatus.values().length);
        Arrays.stream(MaintenanceOpStatus.values()).forEach(e -> MOS.put(e.ordinal(), (MaintenanceOpStatus)((Object)e)));
        MAINTENANCE_OPERATION = new PropertyType<MaintenanceOpType>("MaintenanceOperation"){

            @Override
            public MaintenanceOpType cast(Object value) {
                if (value instanceof MaintenanceOpType) {
                    return (MaintenanceOpType)((Object)value);
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof Number) {
                    return HMSPropertyManager.findOpType(((Number)value).intValue());
                }
                return this.parse(value.toString());
            }

            @Override
            public MaintenanceOpType parse(String str) {
                if (str == null) {
                    return null;
                }
                return MaintenanceOpType.valueOf(str.toUpperCase());
            }

            @Override
            public String format(Object value) {
                if (value instanceof MaintenanceOpType) {
                    return value.toString();
                }
                return null;
            }
        };
        MAINTENANCE_STATUS = new PropertyType<MaintenanceOpStatus>("MaintenanceStatus"){

            @Override
            public MaintenanceOpStatus cast(Object value) {
                if (value instanceof MaintenanceOpStatus) {
                    return (MaintenanceOpStatus)((Object)value);
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof Number) {
                    return HMSPropertyManager.findOpStatus(((Number)value).intValue());
                }
                return this.parse(value.toString());
            }

            @Override
            public MaintenanceOpStatus parse(String str) {
                if (str == null) {
                    return null;
                }
                return MaintenanceOpStatus.valueOf(str.toUpperCase());
            }

            @Override
            public String format(Object value) {
                if (value instanceof MaintenanceOpStatus) {
                    return value.toString();
                }
                return null;
            }
        };
        PropertyType.register(MAINTENANCE_OPERATION);
        PropertyType.register(MAINTENANCE_STATUS);
        TreeMap clusterp = new TreeMap();
        CLUSTER_SCHEMA = new PropertySchema(CLUSTER_PREFIX, 1, clusterp);
        TreeMap databasep = new TreeMap();
        DATABASE_SCHEMA = new PropertySchema(DATABASE_PREFIX, 1, databasep);
        TreeMap tablep = new TreeMap();
        TABLE_SCHEMA = new PropertySchema(TABLE_PREFIX, 1, tablep);
        SCHEMAS = new PropertySchema[]{CLUSTER_SCHEMA, DATABASE_SCHEMA, TABLE_SCHEMA};
    }

    public static enum MaintenanceOpType {
        COMPACTION,
        SNAPSHOT_EXPIRY,
        STATS_REBUILD,
        MV_BUILD,
        MV_REFRESH,
        SHUFFLE_TO_NEW_PART,
        RECOMPRESS,
        REORG;

    }

    public static enum MaintenanceOpStatus {
        MAINTENANCE_NEEDED,
        SCHEDULED,
        IN_PROGRESS,
        DONE,
        CLEANUP_NEEDED,
        FAILED;

    }
}

