/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexFlags;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.RegexSyntaxException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.UnicodeProperties;
import com.oracle.truffle.regex.tregex.parser.CaseFoldTable;
import com.oracle.truffle.regex.tregex.parser.RegexLexer;
import com.oracle.truffle.regex.tregex.parser.Token;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.Map;

public final class JSRegexLexer
extends RegexLexer {
    private static final CodePointSet ID_START = UnicodeProperties.getProperty("ID_Start").union(CodePointSet.createNoDedup(36, 36, 95, 95));
    private static final CodePointSet ID_CONTINUE = UnicodeProperties.getProperty("ID_Continue").union(CodePointSet.createNoDedup(36, 36, 8204, 8205));
    private static final TBitSet SYNTAX_CHARS = TBitSet.valueOf(36, 40, 41, 42, 43, 46, 47, 63, 91, 92, 93, 94, 123, 124, 125);
    private final RegexFlags flags;
    private final CodePointSetAccumulator caseFoldTmp = new CodePointSetAccumulator();

    public JSRegexLexer(RegexSource source, RegexFlags flags) {
        super(source);
        this.flags = flags;
    }

    @Override
    protected boolean featureEnabledIgnoreCase() {
        return this.flags.isIgnoreCase();
    }

    @Override
    protected boolean featureEnabledAZPositionAssertions() {
        return false;
    }

    @Override
    protected boolean featureEnabledBoundedQuantifierEmptyMin() {
        return false;
    }

    @Override
    protected boolean featureEnabledCharClassFirstBracketIsLiteral() {
        return false;
    }

    @Override
    protected boolean featureEnabledForwardReferences() {
        return true;
    }

    @Override
    protected boolean featureEnabledGroupComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledLineComments() {
        return false;
    }

    @Override
    protected boolean featureEnabledOctalEscapes() {
        return !this.flags.isUnicode();
    }

    @Override
    protected boolean featureEnabledUnicodePropertyEscapes() {
        return this.flags.isUnicode();
    }

    @Override
    protected void caseFold(CodePointSetAccumulator charClass) {
        CaseFoldTable.CaseFoldingAlgorithm caseFolding = this.flags.isUnicode() ? CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptUnicode : CaseFoldTable.CaseFoldingAlgorithm.ECMAScriptNonUnicode;
        CaseFoldTable.applyCaseFold(charClass, this.caseFoldTmp, caseFolding);
    }

    @Override
    protected CodePointSet getDotCodePointSet() {
        return this.flags.isDotAll() ? Constants.DOT_ALL : Constants.DOT;
    }

    @Override
    protected CodePointSet getIdContinue() {
        return ID_CONTINUE;
    }

    @Override
    protected CodePointSet getIdStart() {
        return ID_START;
    }

    @Override
    protected int getMaxBackReferenceDigits() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected CodePointSet getPredefinedCharClass(char c) {
        switch (c) {
            case 's': {
                if (this.source.getOptions().isU180EWhitespace()) {
                    return Constants.LEGACY_WHITE_SPACE;
                }
                return Constants.WHITE_SPACE;
            }
            case 'S': {
                if (this.source.getOptions().isU180EWhitespace()) {
                    return Constants.LEGACY_NON_WHITE_SPACE;
                }
                return Constants.NON_WHITE_SPACE;
            }
            case 'd': {
                return Constants.DIGITS;
            }
            case 'D': {
                return Constants.NON_DIGITS;
            }
            case 'w': {
                if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                    return Constants.WORD_CHARS_UNICODE_IGNORE_CASE;
                }
                return Constants.WORD_CHARS;
            }
            case 'W': {
                if (this.flags.isUnicode() && this.flags.isIgnoreCase()) {
                    return Constants.NON_WORD_CHARS_UNICODE_IGNORE_CASE;
                }
                return Constants.NON_WORD_CHARS;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected RegexSyntaxException handleBoundedQuantifierOutOfOrder() {
        return this.syntaxError("Numbers out of order in {} quantifier");
    }

    @Override
    protected Token handleBoundedQuantifierSyntaxError() throws RegexSyntaxException {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Incomplete quantifier");
        }
        this.position = this.getLastTokenPosition() + 1;
        return this.charClass(123);
    }

    @Override
    protected RegexSyntaxException handleCCRangeOutOfOrder(int startPos) {
        return this.syntaxError("Range out of order in character class");
    }

    @Override
    protected void handleCCRangeWithPredefCharClass(int startPos) {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Invalid character class");
        }
    }

    @Override
    protected RegexSyntaxException handleEmptyGroupName() {
        return this.syntaxError("Empty named capture group name");
    }

    @Override
    protected RegexSyntaxException handleGroupRedefinition(String name, int newId, int oldId) {
        return this.syntaxError("Multiple named capture groups with the same name");
    }

    @Override
    protected void handleIncompleteEscapeX() {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Invalid escape");
        }
    }

    @Override
    protected void handleInvalidBackReference(int reference) {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Missing capture group for backreference");
        }
    }

    @Override
    protected void handleInvalidBackReference(String reference) {
        throw this.syntaxError("Missing capture group for backreference");
    }

    private int handleInvalidEscape(int c) {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Invalid escape");
        }
        return c;
    }

    @Override
    protected RegexSyntaxException handleInvalidGroupBeginQ() {
        return this.syntaxError("Invalid group");
    }

    @Override
    protected void handleOctalOutOfRange() {
    }

    @Override
    protected void handleUnfinishedEscape() {
        throw this.syntaxError("Ends with an unfinished escape sequence");
    }

    @Override
    protected void handleUnfinishedGroupComment() {
    }

    @Override
    protected RegexSyntaxException handleUnfinishedGroupQ() {
        return this.syntaxError("Invalid group");
    }

    @Override
    protected void handleUnmatchedRightBrace() {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Unmatched '}'");
        }
    }

    @Override
    protected RegexSyntaxException handleUnmatchedLeftBracket() {
        return this.syntaxError("Unterminated character class");
    }

    @Override
    protected void handleUnmatchedRightBracket() {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Unmatched ']'");
        }
    }

    @Override
    protected int parseCodePointInGroupName() throws RegexSyntaxException {
        if (this.consumingLookahead("\\u")) {
            int unicodeEscape = this.parseUnicodeEscapeChar(true);
            if (unicodeEscape < 0) {
                throw this.syntaxError("Invalid Unicode escape");
            }
            return unicodeEscape;
        }
        int c = this.consumeChar();
        return Character.isHighSurrogate((char)c) ? this.finishSurrogatePair((char)c) : c;
    }

    private String jsParseGroupName() {
        RegexLexer.ParseGroupNameResult result = this.parseGroupName('>');
        switch (result.state) {
            case empty: {
                throw this.handleEmptyGroupName();
            }
            case unterminated: {
                throw this.syntaxError("Unterminated group name");
            }
            case invalidStart: {
                throw this.syntaxError("Invalid character at start of group name");
            }
            case invalidRest: {
                throw this.syntaxError("Invalid character in group name");
            }
            case valid: {
                return result.groupName;
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    @Override
    protected Token parseCustomEscape(char c) {
        if (c == 'k') {
            if (this.flags.isUnicode() || this.hasNamedCaptureGroups()) {
                if (this.atEnd()) {
                    this.handleUnfinishedEscape();
                }
                if (this.consumeChar() != '<') {
                    throw this.syntaxError("Missing group name in named capture group reference");
                }
                String groupName = this.jsParseGroupName();
                if (this.namedCaptureGroups != null && this.namedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference((Integer)this.namedCaptureGroups.get(groupName), false);
                }
                Map<String, Integer> allNamedCaptureGroups = this.getNamedCaptureGroups();
                if (allNamedCaptureGroups != null && allNamedCaptureGroups.containsKey(groupName)) {
                    return Token.createBackReference(allNamedCaptureGroups.get(groupName), false);
                }
                this.handleInvalidBackReference(groupName);
            } else {
                return this.charClass(c);
            }
        }
        return null;
    }

    @Override
    protected int parseCustomEscapeChar(char c, boolean inCharClass) {
        switch (c) {
            case 48: {
                if (this.flags.isUnicode() && this.lookahead(RegexLexer::isDecimalDigit, 1)) {
                    throw this.syntaxError("Invalid escape");
                }
                if (!this.flags.isUnicode() && this.lookahead(RegexLexer::isOctalDigit, 1)) {
                    return this.parseOctal(0);
                }
                return 0;
            }
            case 99: {
                if (this.atEnd()) {
                    this.retreat();
                    return this.handleInvalidControlEscape();
                }
                char controlLetter = this.curChar();
                if (!this.flags.isUnicode() && (JSRegexLexer.isDecimalDigit(controlLetter) || controlLetter == '_') && inCharClass) {
                    this.advance();
                    return controlLetter % 32;
                }
                if (!('a' <= controlLetter && controlLetter <= 'z' || 'A' <= controlLetter && controlLetter <= 'Z')) {
                    this.retreat();
                    return this.handleInvalidControlEscape();
                }
                this.advance();
                return Character.toUpperCase(controlLetter) - 64;
            }
            case 117: {
                int unicodeEscape = this.parseUnicodeEscapeChar(this.flags.isUnicode());
                return unicodeEscape < 0 ? c : unicodeEscape;
            }
        }
        return -1;
    }

    @Override
    protected int parseCustomEscapeCharFallback(int c, boolean inCharClass) {
        if (c == 45) {
            if (!inCharClass) {
                return this.handleInvalidEscape(c);
            }
            return c;
        }
        if (!SYNTAX_CHARS.get(c)) {
            return this.handleInvalidEscape(c);
        }
        return c;
    }

    private char handleInvalidControlEscape() throws RegexSyntaxException {
        if (this.flags.isUnicode()) {
            throw this.syntaxError("Invalid control char escape");
        }
        return '\\';
    }

    @Override
    protected Token parseCustomGroupBeginQ(char charAfterQuestionMark) {
        return null;
    }

    @Override
    protected Token parseGroupLt() {
        this.registerNamedCaptureGroup(this.jsParseGroupName());
        return Token.createCaptureGroupBegin();
    }

    private int parseUnicodeEscapeChar(boolean unicodeMode) throws RegexSyntaxException {
        if (unicodeMode && this.consumingLookahead("{")) {
            int value = this.parseHex(1, Integer.MAX_VALUE, 0x10FFFF);
            if (!this.consumingLookahead("}")) {
                throw this.syntaxError("Invalid Unicode escape");
            }
            return value;
        }
        int value = this.parseHex(4, 4, 65535);
        if (unicodeMode && Character.isHighSurrogate((char)value)) {
            int resetIndex = this.position;
            if (this.consumingLookahead("\\u") && !this.lookahead("{")) {
                char lead = (char)value;
                char trail = (char)this.parseHex(4, 4, 65535);
                if (Character.isLowSurrogate(trail)) {
                    return Character.toCodePoint(lead, trail);
                }
                this.position = resetIndex;
            } else {
                this.position = resetIndex;
            }
        }
        return value;
    }

    private int parseHex(int minDigits, int maxDigits, int maxValue) throws RegexSyntaxException {
        int ret = 0;
        int initialIndex = this.position;
        for (int i = 0; i < maxDigits; ++i) {
            if (this.atEnd() || !JSRegexLexer.isHexDigit(this.curChar())) {
                if (i >= minDigits) break;
                if (this.flags.isUnicode()) {
                    throw this.syntaxError("Invalid Unicode escape");
                }
                this.position = initialIndex;
                return -1;
            }
            char c = this.consumeChar();
            ret *= 16;
            ret = c >= 'a' ? (ret += c - 87) : (c >= 'A' ? (ret += c - 55) : (ret += c - 48));
            if (ret <= maxValue) continue;
            throw this.syntaxError("Invalid Unicode escape");
        }
        return ret;
    }
}

