/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import org.datanucleus.PropertyNames;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    protected StoreManager storeMgr;
    protected final String resourceType;
    protected final String resourceName;
    public static final String RESOURCE_NAME_TX = "tx";
    public static final String RESOURCE_NAME_NONTX = "nontx";

    public AbstractConnectionFactory(StoreManager storeMgr, String resourceName) {
        this.storeMgr = storeMgr;
        this.resourceName = resourceName;
        if (resourceName == null) {
            this.resourceType = null;
            NucleusLogger.CONNECTION.warn("Attempt to create ConnectionFactory with NULL resourceName for connection factory with storeManager=" + StringUtils.toJVMIDString(storeMgr));
        } else {
            this.resourceType = resourceName.equals(RESOURCE_NAME_TX) ? storeMgr.getStringProperty(PropertyNames.PROPERTY_CONNECTION_RESOURCETYPE) : storeMgr.getStringProperty(PropertyNames.PROPERTY_CONNECTION_RESOURCETYPE2);
        }
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public void close() {
        this.storeMgr = null;
    }

    public String toString() {
        return "ConnectionFactory:" + this.resourceName + "[" + StringUtils.toJVMIDString(this) + "]";
    }
}

