/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.secretsmanager.caching.cache;

import com.amazonaws.secretsmanager.caching.SecretCacheConfiguration;
import com.amazonaws.secretsmanager.caching.cache.SecretCacheObject;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import java.util.Objects;

public class SecretCacheVersion
extends SecretCacheObject<GetSecretValueResult> {
    private final String versionId;
    private final int hash;

    public SecretCacheVersion(String secretId, String versionId, AWSSecretsManager client, SecretCacheConfiguration config) {
        super(secretId, client, config);
        this.versionId = versionId;
        this.hash = String.format("%s %s", secretId, versionId).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SecretCacheVersion) {
            return Objects.equals(this.secretId, ((SecretCacheVersion)obj).secretId) && Objects.equals(this.versionId, ((SecretCacheVersion)obj).versionId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        return String.format("SecretCacheVersion: %s %s", this.secretId, this.versionId);
    }

    @Override
    protected GetSecretValueResult executeRefresh() {
        return this.client.getSecretValue(this.updateUserAgent(new GetSecretValueRequest().withSecretId(this.secretId).withVersionId(this.versionId)));
    }

    @Override
    protected GetSecretValueResult getSecretValue(GetSecretValueResult gsvResult) {
        return gsvResult;
    }
}

