/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.FieldDesc;
import org.apache.hadoop.hive.llap.LlapInputSplit;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.NotTezEventHelper;
import org.apache.hadoop.hive.llap.Schema;
import org.apache.hadoop.hive.llap.SubmitWorkInfo;
import org.apache.hadoop.hive.llap.coordinator.LlapCoordinator;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.ext.LlapDaemonInfo;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.security.LlapExtClientJwtHelper;
import org.apache.hadoop.hive.llap.security.LlapSigner;
import org.apache.hadoop.hive.llap.security.LlapTokenLocalClient;
import org.apache.hadoop.hive.llap.tez.Converters;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.HiveSplitGenerator;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SplitLocationInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.TaskLocationHint;
import org.apache.tez.dag.api.TaskSpecBuilder;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.InputConfigureVertexTasksEvent;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.impl.TaskSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="get_splits", value="_FUNC_(string,int) - Returns an array of length int serialized splits for the referenced tables string. Passing length 0 returns only schema data for the compiled query.")
@UDFType(deterministic=false)
public class GenericUDTFGetSplits
extends GenericUDTF {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDTFGetSplits.class);
    private static String sha = null;
    protected transient StringObjectInspector stringOI;
    protected transient IntObjectInspector intOI;
    protected transient JobConf jc;
    private boolean limitQuery;
    protected ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
    protected DataOutput dos = new DataOutputStream(this.bos);
    protected String inputArgQuery;
    protected int inputArgNumSplits;
    protected boolean schemaSplitOnly;

    @Override
    public StructObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        LOG.debug("initializing GenericUDFGetSplits");
        this.validateInput(arguments);
        List<String> names = Arrays.asList("split");
        List<ObjectInspector> fieldOIs = Arrays.asList(PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector);
        StandardStructObjectInspector outputOI = ObjectInspectorFactory.getStandardStructObjectInspector(names, fieldOIs);
        LOG.debug("done initializing GenericUDFGetSplits");
        return outputOI;
    }

    protected void validateInput(ObjectInspector[] arguments) throws UDFArgumentLengthException, UDFArgumentTypeException {
        if (SessionState.get() == null || SessionState.get().getConf() == null) {
            throw new IllegalStateException("Cannot run get splits outside HS2");
        }
        LOG.debug("Initialized conf, jc and metastore connection");
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("The function GET_SPLITS accepts 2 arguments.");
        }
        if (!(arguments[0] instanceof StringObjectInspector)) {
            LOG.error("Got " + arguments[0].getTypeName() + " instead of string.");
            throw new UDFArgumentTypeException(0, "\"string\" is expected at function GET_SPLITS, but \"" + arguments[0].getTypeName() + "\" is found");
        }
        if (!(arguments[1] instanceof IntObjectInspector)) {
            LOG.error("Got " + arguments[1].getTypeName() + " instead of int.");
            throw new UDFArgumentTypeException(1, "\"int\" is expected at function GET_SPLITS, but \"" + arguments[1].getTypeName() + "\" is found");
        }
        this.stringOI = (StringObjectInspector)arguments[0];
        this.intOI = (IntObjectInspector)arguments[1];
    }

    @Override
    public void process(Object[] arguments) throws HiveException {
        this.initArgs(arguments);
        try {
            InputSplit[] splits;
            InputSplit[] inputSplitArray;
            SplitResult splitResult = this.getSplitResult(false);
            if (this.schemaSplitOnly) {
                InputSplit[] inputSplitArray2 = new InputSplit[1];
                inputSplitArray = inputSplitArray2;
                inputSplitArray2[0] = splitResult.schemaSplit;
            } else {
                inputSplitArray = splitResult.actualSplits;
            }
            for (InputSplit s : splits = inputSplitArray) {
                Object[] os = new Object[1];
                this.bos.reset();
                s.write(this.dos);
                byte[] frozen = this.bos.toByteArray();
                os[0] = frozen;
                this.forward(os);
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e);
        }
    }

    protected void initArgs(Object[] arguments) {
        this.inputArgQuery = this.stringOI.getPrimitiveJavaObject(arguments[0]);
        this.inputArgNumSplits = this.intOI.get(arguments[1]);
        this.schemaSplitOnly = this.inputArgNumSplits == 0;
    }

    protected SplitResult getSplitResult(boolean generateLightWeightSplits) throws HiveException, IOException {
        LlapCoordinator coordinator = LlapCoordinator.getInstance();
        if (coordinator == null) {
            throw new HiveException("LLAP coordinator is not initialized; must be running in HS2 with " + HiveConf.ConfVars.LLAP_HS2_ENABLE_COORDINATOR.varname + " enabled");
        }
        ApplicationId extClientAppId = coordinator.createExtClientAppId();
        String externalDagName = SessionState.get().getConf().getVar(HiveConf.ConfVars.HIVE_QUERY_NAME);
        StringBuilder sb = new StringBuilder();
        sb.append("Generated appID ").append(extClientAppId.toString()).append(" for LLAP splits");
        if (externalDagName != null) {
            sb.append(", with externalID ").append(externalDagName);
        }
        LOG.info(sb.toString());
        PlanFragment fragment = this.createPlanFragment(this.inputArgQuery, extClientAppId);
        TezWork tezWork = fragment.work;
        Schema schema = fragment.schema;
        SplitResult splitResult = this.getSplits(this.jc, tezWork, schema, extClientAppId, generateLightWeightSplits);
        this.validateSplitResult(splitResult, generateLightWeightSplits);
        return splitResult;
    }

    private void validateSplitResult(SplitResult splitResult, boolean generateLightWeightSplits) {
        Preconditions.checkNotNull((Object)splitResult.schemaSplit, (Object)"schema split cannot be null");
        if (!this.schemaSplitOnly) {
            InputSplit[] splits = splitResult.actualSplits;
            if (splits.length > 0 && generateLightWeightSplits) {
                Preconditions.checkNotNull((Object)splitResult.planSplit, (Object)"plan split cannot be null");
            }
            LOG.info("Generated {} splits for query {}", (Object)splits.length, (Object)this.inputArgQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlanFragment createPlanFragment(String query, ApplicationId splitsAppId) throws HiveException {
        HiveConf conf = new HiveConf(SessionState.get().getConf());
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION, (String)"none");
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_RESULT_FILEFORMAT, (String)"Llap");
        String originalMode = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE, (String)"llap");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS, (boolean)true);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS, (boolean)true);
        conf.setBoolean("tez.grouping.node.local.only", true);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, (boolean)true);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED, (boolean)false);
        if (this.schemaSplitOnly) {
            try {
                List<FieldSchema> fieldSchemas = ParseUtils.parseQueryAndGetSchema(conf, (String)query);
                Schema schema = new Schema(this.convertSchema(fieldSchemas));
                return new PlanFragment(null, schema, null);
            }
            catch (ParseException e) {
                throw new HiveException((Throwable)e);
            }
        }
        try {
            this.jc = DagUtils.getInstance().createConfiguration(conf);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        HiveTxnManager txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        Driver driver = new Driver(new QueryState.Builder().withHiveConf(conf).nonIsolated().build(), null, txnManager);
        DriverCleanup driverCleanup = new DriverCleanup(driver, txnManager, splitsAppId.toString());
        boolean needsCleanup = true;
        try {
            String validWriteIdString;
            TezWork tezWork;
            boolean fetchTask;
            try {
                driver.compileAndRespond((String)query, false);
            }
            catch (CommandProcessorException e) {
                throw new HiveException("Failed to compile query", (Throwable)e);
            }
            QueryPlan plan = driver.getPlan();
            this.limitQuery = plan.getQueryProperties().getOuterQueryLimit() != -1;
            List<Task<?>> roots = plan.getRootTasks();
            Schema schema = this.convertSchema(plan.getResultSchema());
            boolean bl = fetchTask = plan.getFetchTask() != null;
            if (roots == null || roots.size() != 1 || !(roots.get(0) instanceof TezTask)) {
                if (!fetchTask) throw new HiveException("Was expecting a single TezTask or FetchTask.");
                tezWork = null;
            } else {
                tezWork = (TezWork)((TezTask)roots.get(0)).getWork();
            }
            if (tezWork == null || tezWork.getAllWork().size() != 1 || this.limitQuery) {
                String tableName = "table_" + UUID.randomUUID().toString().replaceAll("-", "");
                String storageFormatString = this.getTempTableStorageFormatString(conf);
                String ctas = "create temporary table " + tableName + " " + storageFormatString + " as " + (String)query;
                LOG.info("Materializing the query for LLAPIF; CTAS: " + ctas);
                driver.releaseLocksAndCommitOrRollback(false);
                driver.releaseResources();
                HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE, (String)originalMode);
                try {
                    driver.run(ctas);
                }
                catch (CommandProcessorException e) {
                    throw new HiveException("Failed to create temp table [" + tableName + "]", (Throwable)e);
                }
                HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE, (String)"llap");
                query = "select * from " + tableName;
                try {
                    driver.compileAndRespond((String)query, true);
                }
                catch (CommandProcessorException e) {
                    throw new HiveException("Failed to select from table [" + tableName + "]", (Throwable)e);
                }
                plan = driver.getPlan();
                roots = plan.getRootTasks();
                schema = this.convertSchema(plan.getResultSchema());
                if (roots == null || roots.size() != 1 || !(roots.get(0) instanceof TezTask)) {
                    throw new HiveException("Was expecting a single TezTask.");
                }
                tezWork = (TezWork)((TezTask)roots.get(0)).getWork();
            } else {
                try {
                    driver.lockAndRespond();
                }
                catch (CommandProcessorException cpr1) {
                    throw new HiveException("Failed to acquire locks", (Throwable)cpr1);
                }
                SessionState.get().addCleanupItem(driverCleanup);
                needsCleanup = false;
            }
            HiveConf driverConf = driver.getConf();
            String validTxnString = driverConf.get("hive.txn.valid.txns");
            if (validTxnString != null) {
                this.jc.set("hive.txn.valid.txns", validTxnString);
            }
            if ((validWriteIdString = driverConf.get("hive.txn.tables.valid.writeids")) != null) {
                assert (validTxnString != null);
                this.jc.set("hive.txn.tables.valid.writeids", validWriteIdString);
            }
            PlanFragment planFragment = new PlanFragment(tezWork, schema, this.jc);
            return planFragment;
        }
        finally {
            if (needsCleanup) {
                if (driverCleanup != null) {
                    try {
                        driverCleanup.close();
                    }
                    catch (IOException err) {
                        throw new HiveException((Throwable)err);
                    }
                } else if (driver != null) {
                    driver.close();
                    driver.destroy();
                }
            }
        }
    }

    private SplitResult getSplits(JobConf job, TezWork work, Schema schema, ApplicationId extClientAppId, boolean generateLightWeightSplits) throws IOException {
        SplitResult splitResult = new SplitResult();
        splitResult.schemaSplit = new LlapInputSplit(0, new byte[0], new byte[0], new byte[0], new SplitLocationInfo[0], new LlapDaemonInfo[0], schema, "", new byte[0], "");
        if (this.schemaSplitOnly) {
            return splitResult;
        }
        DAG dag = DAG.create((String)work.getName());
        dag.setCredentials(job.getCredentials());
        DagUtils utils = DagUtils.getInstance();
        Context ctx = new Context((Configuration)job);
        MapWork mapWork = (MapWork)work.getAllWork().get(0);
        JobConf wxConf = utils.initializeVertexConf(job, ctx, (BaseWork)mapWork);
        Path scratchDir = utils.createTezDir(ctx.getMRScratchDir(), (Configuration)job);
        try {
            LocalResource appJarLr = this.createJarLocalResource(utils.getExecJarPathLocal(ctx.getConf()), utils, (Configuration)job);
            LlapCoordinator coordinator = LlapCoordinator.getInstance();
            if (coordinator == null) {
                throw new IOException("LLAP coordinator is not initialized; must be running in HS2 with " + HiveConf.ConfVars.LLAP_HS2_ENABLE_COORDINATOR.varname + " enabled");
            }
            HiveConf.setVar((Configuration)wxConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID, (String)extClientAppId.toString());
            Vertex wx = utils.createVertex(wxConf, mapWork, scratchDir, work, DagUtils.createTezLrMap(appJarLr, null));
            String vertexName = wx.getName();
            dag.addVertex(wx);
            utils.addCredentials(mapWork, dag, job);
            Preconditions.checkState((boolean)HiveConf.getBoolVar((Configuration)wxConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_GENERATE_CONSISTENT_SPLITS));
            Preconditions.checkState((boolean)HiveConf.getBoolVar((Configuration)wxConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS));
            HiveConf.setIntVar((Configuration)wxConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_INPUT_FS_SERIALIZATION_THRESHOLD, (int)-1);
            HiveSplitGenerator splitGenerator = new HiveSplitGenerator((Configuration)wxConf, mapWork, false, this.inputArgNumSplits);
            List<Event> eventList = splitGenerator.initialize();
            int numGroupedSplitsGenerated = eventList.size() - 1;
            InputSplit[] result = new InputSplit[numGroupedSplitsGenerated];
            InputConfigureVertexTasksEvent configureEvent = (InputConfigureVertexTasksEvent)eventList.get(0);
            List hints = configureEvent.getLocationHint().getTaskLocationHints();
            Preconditions.checkState((hints.size() == numGroupedSplitsGenerated ? 1 : 0) != 0);
            if (LOG.isDebugEnabled()) {
                LOG.debug("NumEvents=" + eventList.size() + ", NumSplits=" + result.length);
            }
            String llapUser = LlapRegistryService.currentUser();
            String queryUser = null;
            byte[] tokenBytes = null;
            LlapSigner signer = null;
            if (UserGroupInformation.isSecurityEnabled()) {
                signer = coordinator.getLlapSigner((Configuration)job);
                queryUser = SessionState.getUserFromAuthenticator();
                if (queryUser == null) {
                    queryUser = UserGroupInformation.getCurrentUser().getUserName();
                    LOG.warn("Cannot determine the session user; using " + queryUser + " instead");
                }
                LlapTokenLocalClient tokenClient = coordinator.getLocalTokenClient((Configuration)job, llapUser);
                Token token = tokenClient.createToken(extClientAppId.toString(), queryUser, true);
                LOG.info("Created the token for remote user: {}", (Object)token);
                this.bos.reset();
                token.write(this.dos);
                tokenBytes = this.bos.toByteArray();
            } else {
                queryUser = UserGroupInformation.getCurrentUser().getUserName();
            }
            Token<JobTokenIdentifier> umbilicalToken = JobTokenCreator.createJobToken(extClientAppId);
            LOG.info("Number of splits: " + numGroupedSplitsGenerated);
            LlapSigner.SignedMessage signedSvs = null;
            byte[] submitWorkBytes = null;
            byte[] emptySubmitWorkBytes = new byte[]{};
            Schema emptySchema = new Schema();
            for (int i = 0; i < numGroupedSplitsGenerated; ++i) {
                TaskSpec taskSpec = new TaskSpecBuilder().constructTaskSpec(dag, vertexName, numGroupedSplitsGenerated, extClientAppId, i);
                if (i == 0) {
                    signedSvs = this.createSignedVertexSpec(signer, taskSpec, extClientAppId, queryUser, extClientAppId.toString());
                    SubmitWorkInfo submitWorkInfo = new SubmitWorkInfo(extClientAppId, System.currentTimeMillis(), numGroupedSplitsGenerated, signedSvs.message, signedSvs.signature, umbilicalToken);
                    submitWorkBytes = SubmitWorkInfo.toBytes((SubmitWorkInfo)submitWorkInfo);
                    if (generateLightWeightSplits) {
                        splitResult.planSplit = new LlapInputSplit(0, submitWorkBytes, new byte[0], new byte[0], new SplitLocationInfo[0], new LlapDaemonInfo[0], new Schema(), "", new byte[0], "");
                    }
                }
                LlapSigner.SignedMessage eventBytes = this.makeEventBytes(wx, vertexName, eventList.get(i + 1), signer);
                SplitLocationInfo[] locations = this.makeLocationHints((TaskLocationHint)hints.get(i));
                LlapDaemonInfo[] llapDaemonInfos = this.populateLlapDaemonInfos(job, locations);
                String jwt = "";
                if (LlapUtil.isCloudDeployment((Configuration)job)) {
                    LlapExtClientJwtHelper llapExtClientJwtHelper = new LlapExtClientJwtHelper((Configuration)job);
                    jwt = llapExtClientJwtHelper.buildJwtForLlap(extClientAppId);
                }
                result[i] = generateLightWeightSplits ? new LlapInputSplit(i, emptySubmitWorkBytes, eventBytes.message, eventBytes.signature, locations, llapDaemonInfos, emptySchema, llapUser, tokenBytes, jwt) : new LlapInputSplit(i, submitWorkBytes, eventBytes.message, eventBytes.signature, locations, llapDaemonInfos, schema, llapUser, tokenBytes, jwt);
            }
            splitResult.actualSplits = result;
            return splitResult;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private SplitLocationInfo[] makeLocationHints(TaskLocationHint hint) {
        Set hosts = hint.getHosts();
        if (hosts == null) {
            LOG.warn("No hosts");
            return new SplitLocationInfo[0];
        }
        if (hosts.size() != 1) {
            LOG.warn("Bad # of locations: " + hosts.size());
        }
        SplitLocationInfo[] locations = new SplitLocationInfo[hosts.size()];
        int j = 0;
        for (String host : hosts) {
            locations[j++] = new SplitLocationInfo(host, false);
        }
        return locations;
    }

    private LlapDaemonInfo[] populateLlapDaemonInfos(JobConf job, SplitLocationInfo[] locations) throws IOException {
        LlapRegistryService registryService = LlapRegistryService.getClient((Configuration)job);
        LlapServiceInstanceSet instanceSet = registryService.getInstances();
        Collection llapServiceInstances = null;
        if (locations.length == 1 && locations[0].getLocation() != null) {
            llapServiceInstances = instanceSet.getByHost(locations[0].getLocation());
        }
        if (CollectionUtils.isEmpty(llapServiceInstances)) {
            llapServiceInstances = instanceSet.getAll();
        }
        Preconditions.checkState((llapServiceInstances.size() > 0 ? 1 : 0) != 0, (Object)"Unable to find any of the llap instances in zk registry");
        LlapDaemonInfo[] llapDaemonInfos = new LlapDaemonInfo[llapServiceInstances.size()];
        int count = 0;
        for (LlapServiceInstance inst : llapServiceInstances) {
            LlapDaemonInfo info = LlapUtil.isCloudDeployment((Configuration)job) ? new LlapDaemonInfo(inst.getExternalHostname(), inst.getExternalClientsRpcPort(), inst.getOutputFormatPort()) : new LlapDaemonInfo(inst.getHost(), inst.getRpcPort(), inst.getOutputFormatPort());
            llapDaemonInfos[count++] = info;
        }
        return llapDaemonInfos;
    }

    private LlapSigner.SignedMessage makeEventBytes(Vertex wx, String vertexName, Event event, LlapSigner signer) throws IOException {
        assert (event instanceof InputDataInformationEvent);
        List<RootInputLeafOutput<InputDescriptor, InputInitializerDescriptor>> inputs = TaskSpecBuilder.getVertexInputs(wx);
        Preconditions.checkState((inputs.size() == 1 ? 1 : 0) != 0);
        LlapSigner.Signable signableNte = NotTezEventHelper.createSignableNotTezEvent((InputDataInformationEvent)((InputDataInformationEvent)event), (String)vertexName, (String)inputs.get(0).getName());
        if (signer != null) {
            return signer.serializeAndSign(signableNte);
        }
        LlapSigner.SignedMessage sm = new LlapSigner.SignedMessage();
        sm.message = signableNte.serialize();
        return sm;
    }

    private LlapSigner.SignedMessage createSignedVertexSpec(LlapSigner signer, TaskSpec taskSpec, ApplicationId applicationId, String queryUser, String queryIdString) throws IOException {
        LlapDaemonProtocolProtos.QueryIdentifierProto queryIdentifierProto = LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString(applicationId.toString()).setDagIndex(taskSpec.getDagIdentifier()).setAppAttemptNumber(0).build();
        final LlapDaemonProtocolProtos.SignableVertexSpec.Builder svsb = Converters.constructSignableVertexSpec((TaskSpec)taskSpec, (LlapDaemonProtocolProtos.QueryIdentifierProto)queryIdentifierProto, (String)applicationId.toString(), (String)queryUser, (String)queryIdString);
        svsb.setIsExternalSubmission(true);
        if (signer == null) {
            LlapSigner.SignedMessage result = new LlapSigner.SignedMessage();
            result.message = GenericUDTFGetSplits.serializeVertexSpec(svsb);
            return result;
        }
        return signer.serializeAndSign(new LlapSigner.Signable(){

            public void setSignInfo(int masterKeyId) {
                svsb.setSignatureKeyId((long)masterKeyId);
            }

            public byte[] serialize() throws IOException {
                return GenericUDTFGetSplits.serializeVertexSpec(svsb);
            }
        });
    }

    private static byte[] serializeVertexSpec(LlapDaemonProtocolProtos.SignableVertexSpec.Builder svsb) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        svsb.build().writeTo((OutputStream)os);
        return os.toByteArray();
    }

    private LocalResource createJarLocalResource(String localJarPath, DagUtils utils, Configuration conf) throws IOException, IllegalArgumentException, FileNotFoundException {
        FileStatus destDirStatus = utils.getHiveJarDirectory(conf);
        assert (destDirStatus != null);
        Path destDirPath = destDirStatus.getPath();
        Path localFile = new Path(localJarPath);
        if (sha == null || !destDirPath.toString().contains(sha)) {
            sha = this.getSha(localFile, conf);
        }
        Object destFileName = localFile.getName();
        destFileName = FilenameUtils.removeExtension((String)destFileName) + "-" + sha + "." + FilenameUtils.getExtension((String)destFileName);
        Path destFile = new Path(destDirPath.toString() + "/" + (String)destFileName);
        return utils.localizeResource(localFile, destFile, LocalResourceType.FILE, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSha(Path localFile, Configuration conf) throws IOException, IllegalArgumentException {
        try (InputStream is = null;){
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
            is = localFs.open(localFile);
            String string = DigestUtils.sha256Hex((InputStream)is);
            return string;
        }
    }

    private List<FieldDesc> convertSchema(List<FieldSchema> fieldSchemas) {
        ArrayList<FieldDesc> colDescs = new ArrayList<FieldDesc>();
        for (FieldSchema fs : fieldSchemas) {
            String colName = fs.getName();
            String typeString = fs.getType();
            colDescs.add(new FieldDesc(colName, TypeInfoUtils.getTypeInfoFromTypeString((String)typeString)));
        }
        return colDescs;
    }

    private Schema convertSchema(org.apache.hadoop.hive.metastore.api.Schema schema) {
        return new Schema(this.convertSchema(schema.getFieldSchemas()));
    }

    private String getTempTableStorageFormatString(HiveConf conf) {
        String formatString = "";
        String storageFormatOption = conf.getVar(HiveConf.ConfVars.LLAP_EXTERNAL_SPLITS_TEMP_TABLE_STORAGE_FORMAT).toLowerCase();
        if (storageFormatOption.equals("text")) {
            formatString = "stored as textfile";
        } else if (storageFormatOption.equals("orc")) {
            formatString = "stored as orc";
        }
        return formatString;
    }

    @Override
    public void close() throws HiveException {
    }

    static class SplitResult {
        InputSplit schemaSplit;
        InputSplit planSplit;
        InputSplit[] actualSplits;

        SplitResult() {
        }
    }

    public static class PlanFragment {
        public JobConf jc;
        public TezWork work;
        public Schema schema;

        public PlanFragment(TezWork work, Schema schema, JobConf jc) {
            this.work = work;
            this.schema = schema;
            this.jc = jc;
        }
    }

    private static class DriverCleanup
    implements Closeable {
        private final Driver driver;
        private final HiveTxnManager txnManager;
        private final String applicationId;

        public DriverCleanup(Driver driver, HiveTxnManager txnManager, String applicationId) {
            this.driver = driver;
            this.txnManager = txnManager;
            this.applicationId = applicationId;
        }

        @Override
        public void close() throws IOException {
            try {
                LOG.info("DriverCleanup for LLAP splits: {}", (Object)this.applicationId);
                this.driver.releaseLocksAndCommitOrRollback(true);
                this.driver.close();
                this.driver.destroy();
                this.txnManager.closeTxnManager();
            }
            catch (Exception err) {
                LOG.error("Error closing driver resources", (Throwable)err);
                throw new IOException(err);
            }
        }

        public String toString() {
            return "DriverCleanup for LLAP splits: " + this.applicationId;
        }
    }

    private static class JobTokenCreator {
        private JobTokenCreator() {
        }

        private static Token<JobTokenIdentifier> createJobToken(ApplicationId applicationId) {
            String tokenIdentifier = applicationId.toString();
            JobTokenIdentifier identifier = new JobTokenIdentifier(new Text(tokenIdentifier));
            Token sessionToken = new Token((TokenIdentifier)identifier, (SecretManager)new JobTokenSecretManager(new Configuration()));
            sessionToken.setService(identifier.getJobId());
            return sessionToken;
        }
    }
}

