/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToDate;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="date", value="CAST(<Date string> as DATE) - Returns the date represented by the date string.", extended="date_string is a string in the format 'yyyy-MM-dd.'Example:\n   > SELECT CAST('2009-01-01' AS DATE) FROM src LIMIT 1;\n  '2009-01-01'")
@VectorizedExpressions(value={CastStringToDate.class, CastTimestampToDate.class})
public class GenericUDFToDate
extends GenericUDF {
    private final transient ObjectInspectorConverters.Converter[] dateConverters = new ObjectInspectorConverters.Converter[1];
    private final transient PrimitiveObjectInspector.PrimitiveCategory[] dateInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgGroups(arguments, 0, this.dateInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainDateConverter(arguments, 0, this.dateInputTypes, this.dateConverters);
        return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.dateConverters[0].convert(arguments[0].get());
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "CAST( " + children[0] + " AS DATE)";
    }
}

