/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.variant.Variant;
import org.apache.hadoop.hive.serde2.variant.VariantBuilder;

@Description(name="parse_json", value="_FUNC_(json_string) - Parses a JSON string into a VARIANT type", extended="Example:\n  > SELECT _FUNC_('{\"a\":5}');\n  {\"a\":5}")
public class GenericUDFParseJson
extends GenericUDF {
    private PrimitiveObjectInspector inputOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("parse_json requires one argument");
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING) {
            throw new UDFArgumentTypeException(0, "Only string input is accepted");
        }
        this.inputOI = (PrimitiveObjectInspector)arguments[0];
        return ObjectInspectorFactory.getVariantObjectInspector();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        String json = this.inputOI.getPrimitiveJavaObject(input).toString();
        try {
            Variant variant = VariantBuilder.parseJson((String)json, (boolean)true);
            return List.of(variant.getMetadata(), variant.getValue());
        }
        catch (IOException e) {
            throw new HiveException("Failed to parse JSON: " + json, (Throwable)e);
        }
    }

    @Override
    public String getDisplayString(String[] children) {
        return "parse_json(" + children[0] + ")";
    }
}

