/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="cardinality_violation", value="_FUNC_(n0, n1...) - raises Cardinality Violation")
public class GenericUDFCardinalityViolation
extends GenericUDF {
    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        StringBuilder nonUniqueKey = new StringBuilder();
        for (GenericUDF.DeferredObject t : arguments) {
            if (nonUniqueKey.length() > 0) {
                nonUniqueKey.append(',');
            }
            nonUniqueKey.append(t.get());
        }
        throw new RuntimeException("Cardinality Violation in Merge statement: " + String.valueOf(nonUniqueKey));
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("cardinality_violation", children, ",");
    }
}

