/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.LogUtils;
import org.apache.hadoop.hive.ql.udf.esri.ST_Geometry;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="ST_AsJSON", value="_FUNC_(ST_Geometry) - return JSON representation of ST_Geometry\n", extended="Example:\n  SELECT _FUNC_(ST_Point(1.0, 2.0)) from onerow; -- {\"x\":1.0,\"y\":2.0}\n  SELECT _FUNC_(ST_SetSRID(ST_Point(1, 1), 4326)) from onerow; -- {\"x\":1.0,\"y\":1.0,\"spatialReference\":{\"wkid\":4326}}")
public class ST_AsJson
extends ST_Geometry {
    static final Logger LOG = LoggerFactory.getLogger((String)ST_AsJson.class.getName());

    public Text evaluate(BytesWritable geomref) {
        if (geomref == null || geomref.getLength() == 0) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(geomref);
        if (ogcGeometry == null) {
            LogUtils.Log_ArgumentsNull(LOG);
            return null;
        }
        Geometry esriGeom = ogcGeometry.getEsriGeometry();
        int wkid = GeometryUtils.getWKID(geomref);
        return new Text(GeometryEngine.geometryToJson((int)wkid, (Geometry)esriGeom));
    }
}

